<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ChangeLogEntry.
 */
class ChangeLogEntry  {

  /*
   * @type long
   */
  public $version;

  /*
   * @type String
   */
  public $itemUid;

  /*
   * @type String
   */
  public $itemExtId;

  /*
   * @type String
   */
  public $author;

  /*
   * @type ChangeLogEntryType
   */
  public $type;

  /*
   * @type javautilDate
   */
  public $date;

  /*
   * @type String
   */
  public $origin;

  /*
   * @type long
   */
  public $internalId;

  /*
   * @type long
   */
  public $weightSeed;

  /*
   * Constructor
   */
  public function __construct() {
    $this->version = 0;
    $this->itemUid = "";
    $this->itemExtId = "";
    $this->author = "";
    $this->date = null;
    $this->origin = "";
    $this->internalId = 0;
    $this->weightSeed = 0;
  }

  public function toMap() {
    $data = array(    
        "version" => empty($this->version) ? null : $this->version,    
        "itemUid" => empty($this->itemUid) ? null : $this->itemUid,    
        "itemExtId" => empty($this->itemExtId) ? null : $this->itemExtId,    
        "author" => empty($this->author) ? null : $this->author,    
        "type" => empty($this->type) ? null : $this->type,    
        "date" => empty($this->date) ? null : $this->date,    
        "origin" => empty($this->origin) ? null : $this->origin,    
        "internalId" => empty($this->internalId) ? null : $this->internalId,    
        "weightSeed" => empty($this->weightSeed) ? null : $this->weightSeed);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
