/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerUpdatesResultInErrorGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ContainerUpdatesResult.InError> {

	public ContainerUpdatesResultInErrorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ContainerUpdatesResult.InError deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ContainerUpdatesResult.InError ret = new net.bluemind.core.container.model.ContainerUpdatesResult.InError();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerUpdatesResult.InError ret, JSONObject json) {

		JSONValue messageJSON = json.get("message");
		ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		JSONValue errorCodeJSON = json.get("errorCode");
		ret.errorCode =  new net.bluemind.core.api.fault.gwt.serder.ErrorCodeGwtSerDer().deserialize(errorCodeJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ContainerUpdatesResult.InError o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerUpdatesResult.InError o, JSONObject ret) {

		ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		ret.put("errorCode",  new net.bluemind.core.api.fault.gwt.serder.ErrorCodeGwtSerDer().serialize( o.errorCode ));
	}
}