/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerModifiableDescriptorGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ContainerModifiableDescriptor> {

	public ContainerModifiableDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ContainerModifiableDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ContainerModifiableDescriptor ret = new net.bluemind.core.container.model.ContainerModifiableDescriptor();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerModifiableDescriptor ret, JSONObject json) {

		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue defaultContainerJSON = json.get("defaultContainer");
		ret.defaultContainer =  GwtSerDerUtils.BOOLEAN.deserialize(defaultContainerJSON);
		JSONValue deletedJSON = json.get("deleted");
		ret.deleted =  GwtSerDerUtils.BOOLEAN.deserialize(deletedJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ContainerModifiableDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerModifiableDescriptor o, JSONObject ret) {

		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("defaultContainer",  GwtSerDerUtils.BOOLEAN.serialize( o.defaultContainer ));
		ret.put("deleted",  GwtSerDerUtils.BOOLEAN.serialize( o.deleted ));
	}
}