/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerChangesetGwtSerDer<T> implements GwtSerDer<net.bluemind.core.container.model.ContainerChangeset<T>> {

	private GwtSerDer<T> paramSerDerT;

	public ContainerChangesetGwtSerDer(GwtSerDer<T> paramSerDerT ) {
		this.paramSerDerT = paramSerDerT;
	}

	@Override
	public net.bluemind.core.container.model.ContainerChangeset<T> deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ContainerChangeset<T> ret = new net.bluemind.core.container.model.ContainerChangeset<T>();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerChangeset<T> ret, JSONObject json) {

		JSONValue createdJSON = json.get("created");
		ret.created =  new GwtSerDerUtils.ListSerDer<>(paramSerDerT).deserialize(createdJSON);
		JSONValue updatedJSON = json.get("updated");
		ret.updated =  new GwtSerDerUtils.ListSerDer<>(paramSerDerT).deserialize(updatedJSON);
		JSONValue deletedJSON = json.get("deleted");
		ret.deleted =  new GwtSerDerUtils.ListSerDer<>(paramSerDerT).deserialize(deletedJSON);
		JSONValue versionJSON = json.get("version");
		ret.version =  GwtSerDerUtils.LONG.deserialize(versionJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ContainerChangeset<T> o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerChangeset<T> o, JSONObject ret) {

		ret.put("created",  new GwtSerDerUtils.ListSerDer<>(paramSerDerT).serialize( o.created ));
		ret.put("updated",  new GwtSerDerUtils.ListSerDer<>(paramSerDerT).serialize( o.updated ));
		ret.put("deleted",  new GwtSerDerUtils.ListSerDer<>(paramSerDerT).serialize( o.deleted ));
		ret.put("version",  GwtSerDerUtils.LONG.serialize( o.version ));
	}
}