/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.core.container.model.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsItemFlag extends JavaScriptObject {

	protected JsItemFlag() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsItemFlag Seen()
	/*-{
		return "Seen";
	}-*/;

	public static final native JsItemFlag Deleted()
	/*-{
		return "Deleted";
	}-*/;

	public static final native JsItemFlag Important()
	/*-{
		return "Important";
	}-*/;

	public static final JsItemFlag create(net.bluemind.core.container.model.ItemFlag value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case Seen:
				return Seen();
			case Deleted:
				return Deleted();
			case Important:
				return Important();
			default:
				return null;
			}
		}
	}
}