/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.core.container.model.acl.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsVerb extends JavaScriptObject {

	protected JsVerb() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsVerb Invitation()
	/*-{
		return "Invitation";
	}-*/;

	public static final native JsVerb Freebusy()
	/*-{
		return "Freebusy";
	}-*/;

	public static final native JsVerb SendOnBehalf()
	/*-{
		return "SendOnBehalf";
	}-*/;

	public static final native JsVerb Read()
	/*-{
		return "Read";
	}-*/;

	public static final native JsVerb Write()
	/*-{
		return "Write";
	}-*/;

	public static final native JsVerb Manage()
	/*-{
		return "Manage";
	}-*/;

	public static final native JsVerb All()
	/*-{
		return "All";
	}-*/;

	public static final JsVerb create(net.bluemind.core.container.model.acl.Verb value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case Invitation:
				return Invitation();
			case Freebusy:
				return Freebusy();
			case SendOnBehalf:
				return SendOnBehalf();
			case Read:
				return Read();
			case Write:
				return Write();
			case Manage:
				return Manage();
			case All:
				return All();
			default:
				return null;
			}
		}
	}
}