/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class InternalContainersByLocationEndpointPromise implements net.bluemind.core.container.api.IInternalContainersByLocationPromise {

	private net.bluemind.core.container.api.IInternalContainersByLocationAsync impl;

	public InternalContainersByLocationEndpointPromise(net.bluemind.core.container.api.IInternalContainersByLocationAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>> listByTypeAndOwner(net.bluemind.core.container.api.ContainerQuery query  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>> ret = new CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>>();
		AsyncHandler<List<net.bluemind.core.container.model.BaseContainerDescriptor>> handler = new AsyncHandler<List<net.bluemind.core.container.model.BaseContainerDescriptor>>() {
			public void success(List<net.bluemind.core.container.model.BaseContainerDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.listByTypeAndOwner(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>> listByType(net.bluemind.core.container.api.ContainerQuery query  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>> ret = new CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>>();
		AsyncHandler<List<net.bluemind.core.container.model.BaseContainerDescriptor>> handler = new AsyncHandler<List<net.bluemind.core.container.model.BaseContainerDescriptor>>() {
			public void success(List<net.bluemind.core.container.model.BaseContainerDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.listByType(query,  handler);
		return ret;
	}

}
