/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class ContainersEndpointPromise implements net.bluemind.core.container.api.IContainersPromise {

	private net.bluemind.core.container.api.IContainersAsync impl;

	public ContainersEndpointPromise(net.bluemind.core.container.api.IContainersAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ContainerDescriptor>> all(net.bluemind.core.container.api.ContainerQuery query  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ContainerDescriptor>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ContainerDescriptor>>();
		AsyncHandler<List<net.bluemind.core.container.model.ContainerDescriptor>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ContainerDescriptor>>() {
			public void success(List<net.bluemind.core.container.model.ContainerDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.all(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ContainerDescriptor>> getContainers(List<String> containerIds  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ContainerDescriptor>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ContainerDescriptor>>();
		AsyncHandler<List<net.bluemind.core.container.model.ContainerDescriptor>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ContainerDescriptor>>() {
			public void success(List<net.bluemind.core.container.model.ContainerDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getContainers(containerIds,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setAccessControlList(String uid ,  List<net.bluemind.core.container.model.acl.AccessControlEntry> entries  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setAccessControlList(uid, entries,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.core.container.model.ContainerModifiableDescriptor descriptor  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, descriptor,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>> allLight(net.bluemind.core.container.api.ContainerQuery query  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>> ret = new CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>>();
		AsyncHandler<List<net.bluemind.core.container.model.BaseContainerDescriptor>> handler = new AsyncHandler<List<net.bluemind.core.container.model.BaseContainerDescriptor>>() {
			public void success(List<net.bluemind.core.container.model.BaseContainerDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allLight(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ContainerDescriptor>> allForUser(String domainUid ,  String userUid ,  net.bluemind.core.container.api.ContainerQuery query  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ContainerDescriptor>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ContainerDescriptor>>();
		AsyncHandler<List<net.bluemind.core.container.model.ContainerDescriptor>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ContainerDescriptor>>() {
			public void success(List<net.bluemind.core.container.model.ContainerDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allForUser(domainUid, userUid, query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>> getContainersLight(List<String> containerIds  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>> ret = new CompletableFuture<List<net.bluemind.core.container.model.BaseContainerDescriptor>>();
		AsyncHandler<List<net.bluemind.core.container.model.BaseContainerDescriptor>> handler = new AsyncHandler<List<net.bluemind.core.container.model.BaseContainerDescriptor>>() {
			public void success(List<net.bluemind.core.container.model.BaseContainerDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getContainersLight(containerIds,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor> get(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor>();
		AsyncHandler<net.bluemind.core.container.model.ContainerDescriptor> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerDescriptor>() {
			public void success(net.bluemind.core.container.model.ContainerDescriptor value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.get(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.core.container.model.ContainerDescriptor descriptor  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, descriptor,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor> getIfPresent(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor>();
		AsyncHandler<net.bluemind.core.container.model.ContainerDescriptor> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerDescriptor>() {
			public void success(net.bluemind.core.container.model.ContainerDescriptor value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getIfPresent(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor> getForUser(String domainUid ,  String userUid ,  String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerDescriptor>();
		AsyncHandler<net.bluemind.core.container.model.ContainerDescriptor> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerDescriptor>() {
			public void success(net.bluemind.core.container.model.ContainerDescriptor value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getForUser(domainUid, userUid, uid,  handler);
		return ret;
	}

}
