/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardRelatedGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Related> {

	public VCardRelatedGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Related deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Related ret = new net.bluemind.addressbook.api.VCard.Related();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Related ret, JSONObject json) {

		JSONValue spouseJSON = json.get("spouse");
		ret.spouse =  GwtSerDerUtils.STRING.deserialize(spouseJSON);
		JSONValue managerJSON = json.get("manager");
		ret.manager =  GwtSerDerUtils.STRING.deserialize(managerJSON);
		JSONValue assistantJSON = json.get("assistant");
		ret.assistant =  GwtSerDerUtils.STRING.deserialize(assistantJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Related o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Related o, JSONObject ret) {

		ret.put("spouse",  GwtSerDerUtils.STRING.serialize( o.spouse ));
		ret.put("manager",  GwtSerDerUtils.STRING.serialize( o.manager ));
		ret.put("assistant",  GwtSerDerUtils.STRING.serialize( o.assistant ));
	}
}