/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardParameterGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Parameter> {

	public VCardParameterGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Parameter deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Parameter ret = new net.bluemind.addressbook.api.VCard.Parameter();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Parameter ret, JSONObject json) {

		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue valueJSON = json.get("value");
		ret.value =  GwtSerDerUtils.STRING.deserialize(valueJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Parameter o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Parameter o, JSONObject ret) {

		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("value",  GwtSerDerUtils.STRING.serialize( o.value ));
	}
}