/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardOrganizationalGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Organizational> {

	public VCardOrganizationalGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Organizational deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Organizational ret = new net.bluemind.addressbook.api.VCard.Organizational();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Organizational ret, JSONObject json) {

		JSONValue titleJSON = json.get("title");
		ret.title =  GwtSerDerUtils.STRING.deserialize(titleJSON);
		JSONValue roleJSON = json.get("role");
		ret.role =  GwtSerDerUtils.STRING.deserialize(roleJSON);
		JSONValue orgJSON = json.get("org");
		ret.org =  new net.bluemind.addressbook.api.gwt.serder.VCardOrganizationalOrgGwtSerDer().deserialize(orgJSON);
		JSONValue memberJSON = json.get("member");
		ret.member =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardOrganizationalMemberGwtSerDer()).deserialize(memberJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Organizational o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Organizational o, JSONObject ret) {

		ret.put("title",  GwtSerDerUtils.STRING.serialize( o.title ));
		ret.put("role",  GwtSerDerUtils.STRING.serialize( o.role ));
		ret.put("org",  new net.bluemind.addressbook.api.gwt.serder.VCardOrganizationalOrgGwtSerDer().serialize( o.org ));
		ret.put("member",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardOrganizationalMemberGwtSerDer()).serialize( o.member ));
	}
}