/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardCommunicationsGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Communications> {

	public VCardCommunicationsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Communications deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Communications ret = new net.bluemind.addressbook.api.VCard.Communications();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Communications ret, JSONObject json) {

		JSONValue telsJSON = json.get("tels");
		ret.tels =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsTelGwtSerDer()).deserialize(telsJSON);
		JSONValue emailsJSON = json.get("emails");
		ret.emails =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsEmailGwtSerDer()).deserialize(emailsJSON);
		JSONValue imppsJSON = json.get("impps");
		ret.impps =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsImppGwtSerDer()).deserialize(imppsJSON);
		JSONValue langsJSON = json.get("langs");
		ret.langs =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsLangGwtSerDer()).deserialize(langsJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Communications o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Communications o, JSONObject ret) {

		ret.put("tels",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsTelGwtSerDer()).serialize( o.tels ));
		ret.put("emails",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsEmailGwtSerDer()).serialize( o.emails ));
		ret.put("impps",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsImppGwtSerDer()).serialize( o.impps ));
		ret.put("langs",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsLangGwtSerDer()).serialize( o.langs ));
	}
}