/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class AddressBookDescriptorGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.AddressBookDescriptor> {

	public AddressBookDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.AddressBookDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.AddressBookDescriptor ret = new net.bluemind.addressbook.api.AddressBookDescriptor();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.AddressBookDescriptor ret, JSONObject json) {

		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue domainUidJSON = json.get("domainUid");
		ret.domainUid =  GwtSerDerUtils.STRING.deserialize(domainUidJSON);
		JSONValue ownerJSON = json.get("owner");
		ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		JSONValue systemJSON = json.get("system");
		ret.system =  GwtSerDerUtils.BOOLEAN.deserialize(systemJSON);
		JSONValue settingsJSON = json.get("settings");
		ret.settings =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(settingsJSON);
		JSONValue orgUnitUidJSON = json.get("orgUnitUid");
		ret.orgUnitUid =  GwtSerDerUtils.STRING.deserialize(orgUnitUidJSON);
		JSONValue expectedIdJSON = json.get("expectedId");
		ret.expectedId =  GwtSerDerUtils.LONG.deserialize(expectedIdJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.AddressBookDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.AddressBookDescriptor o, JSONObject ret) {

		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("domainUid",  GwtSerDerUtils.STRING.serialize( o.domainUid ));
		ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		ret.put("system",  GwtSerDerUtils.BOOLEAN.serialize( o.system ));
		ret.put("settings",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.settings ));
		ret.put("orgUnitUid",  GwtSerDerUtils.STRING.serialize( o.orgUnitUid ));
		ret.put("expectedId",  GwtSerDerUtils.LONG.serialize( o.expectedId ));
	}
}