/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.tag.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class TagChangesItemAddGwtSerDer implements GwtSerDer<net.bluemind.tag.api.TagChanges.ItemAdd> {

	public TagChangesItemAddGwtSerDer( ) {
	}

	@Override
	public net.bluemind.tag.api.TagChanges.ItemAdd deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.tag.api.TagChanges.ItemAdd ret = new net.bluemind.tag.api.TagChanges.ItemAdd();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.tag.api.TagChanges.ItemAdd ret, JSONObject json) {

		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		JSONValue valueJSON = json.get("value");
		ret.value =  new net.bluemind.tag.api.gwt.serder.TagGwtSerDer().deserialize(valueJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.tag.api.TagChanges.ItemAdd o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.tag.api.TagChanges.ItemAdd o, JSONObject ret) {

		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		ret.put("value",  new net.bluemind.tag.api.gwt.serder.TagGwtSerDer().serialize( o.value ));
	}
}