/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class UserAccountGwtSerDer implements GwtSerDer<net.bluemind.user.api.UserAccount> {

	public UserAccountGwtSerDer( ) {
	}

	@Override
	public net.bluemind.user.api.UserAccount deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.user.api.UserAccount ret = new net.bluemind.user.api.UserAccount();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.user.api.UserAccount ret, JSONObject json) {

		JSONValue loginJSON = json.get("login");
		ret.login =  GwtSerDerUtils.STRING.deserialize(loginJSON);
		JSONValue credentialsJSON = json.get("credentials");
		ret.credentials =  GwtSerDerUtils.STRING.deserialize(credentialsJSON);
		JSONValue additionalSettingsJSON = json.get("additionalSettings");
		ret.additionalSettings =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(additionalSettingsJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.user.api.UserAccount o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.user.api.UserAccount o, JSONObject ret) {

		ret.put("login",  GwtSerDerUtils.STRING.serialize( o.login ));
		ret.put("credentials",  GwtSerDerUtils.STRING.serialize( o.credentials ));
		ret.put("additionalSettings",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.additionalSettings ));
	}
}