/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class UserMailIdentitiesEndpointPromise implements net.bluemind.user.api.IUserMailIdentitiesPromise {

	private net.bluemind.user.api.IUserMailIdentitiesAsync impl;

	public UserMailIdentitiesEndpointPromise(net.bluemind.user.api.IUserMailIdentitiesAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.user.api.UserMailIdentity identity  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, identity,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setDefault(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setDefault(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.mailbox.identity.api.IdentityDescription>> getAvailableIdentities() {
		
		CompletableFuture<List<net.bluemind.mailbox.identity.api.IdentityDescription>> ret = new CompletableFuture<List<net.bluemind.mailbox.identity.api.IdentityDescription>>();
		AsyncHandler<List<net.bluemind.mailbox.identity.api.IdentityDescription>> handler = new AsyncHandler<List<net.bluemind.mailbox.identity.api.IdentityDescription>>() {
			public void success(List<net.bluemind.mailbox.identity.api.IdentityDescription> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getAvailableIdentities( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.user.api.UserMailIdentity> get(String uid  ) {
		
		CompletableFuture<net.bluemind.user.api.UserMailIdentity> ret = new CompletableFuture<net.bluemind.user.api.UserMailIdentity>();
		AsyncHandler<net.bluemind.user.api.UserMailIdentity> handler = new AsyncHandler<net.bluemind.user.api.UserMailIdentity>() {
			public void success(net.bluemind.user.api.UserMailIdentity value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.get(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.user.api.UserMailIdentity identity  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, identity,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.mailbox.identity.api.IdentityDescription>> getIdentities() {
		
		CompletableFuture<List<net.bluemind.mailbox.identity.api.IdentityDescription>> ret = new CompletableFuture<List<net.bluemind.mailbox.identity.api.IdentityDescription>>();
		AsyncHandler<List<net.bluemind.mailbox.identity.api.IdentityDescription>> handler = new AsyncHandler<List<net.bluemind.mailbox.identity.api.IdentityDescription>>() {
			public void success(List<net.bluemind.mailbox.identity.api.IdentityDescription> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getIdentities( handler);
		return ret;
	}

}
