/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class UserExternalAccountEndpointPromise implements net.bluemind.user.api.IUserExternalAccountPromise {

	private net.bluemind.user.api.IUserExternalAccountAsync impl;

	public UserExternalAccountEndpointPromise(net.bluemind.user.api.IUserExternalAccountAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.user.api.UserAccountInfo>> getAll() {
		
		CompletableFuture<List<net.bluemind.user.api.UserAccountInfo>> ret = new CompletableFuture<List<net.bluemind.user.api.UserAccountInfo>>();
		AsyncHandler<List<net.bluemind.user.api.UserAccountInfo>> handler = new AsyncHandler<List<net.bluemind.user.api.UserAccountInfo>>() {
			public void success(List<net.bluemind.user.api.UserAccountInfo> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getAll( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deleteAll() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteAll( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String system ,  net.bluemind.user.api.UserAccount account  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(system, account,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String system  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(system,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.user.api.UserAccount> get(String system  ) {
		
		CompletableFuture<net.bluemind.user.api.UserAccount> ret = new CompletableFuture<net.bluemind.user.api.UserAccount>();
		AsyncHandler<net.bluemind.user.api.UserAccount> handler = new AsyncHandler<net.bluemind.user.api.UserAccount>() {
			public void success(net.bluemind.user.api.UserAccount value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.get(system,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String system ,  net.bluemind.user.api.UserAccount account  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(system, account,  handler);
		return ret;
	}

}
