/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.task.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class TaskStatusGwtSerDer implements GwtSerDer<net.bluemind.core.task.api.TaskStatus> {

	public TaskStatusGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.task.api.TaskStatus deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.task.api.TaskStatus ret = new net.bluemind.core.task.api.TaskStatus();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.task.api.TaskStatus ret, JSONObject json) {

		JSONValue stepsJSON = json.get("steps");
		ret.steps =  GwtSerDerUtils.DOUBLE.deserialize(stepsJSON);
		JSONValue progressJSON = json.get("progress");
		ret.progress =  GwtSerDerUtils.DOUBLE.deserialize(progressJSON);
		JSONValue lastLogEntryJSON = json.get("lastLogEntry");
		ret.lastLogEntry =  GwtSerDerUtils.STRING.deserialize(lastLogEntryJSON);
		JSONValue stateJSON = json.get("state");
		ret.state =  new net.bluemind.core.task.api.gwt.serder.TaskStatusStateGwtSerDer().deserialize(stateJSON);
		JSONValue resultJSON = json.get("result");
		ret.result =  GwtSerDerUtils.STRING.deserialize(resultJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.task.api.TaskStatus o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.task.api.TaskStatus o, JSONObject ret) {

		ret.put("steps",  GwtSerDerUtils.DOUBLE.serialize( o.steps ));
		ret.put("progress",  GwtSerDerUtils.DOUBLE.serialize( o.progress ));
		ret.put("lastLogEntry",  GwtSerDerUtils.STRING.serialize( o.lastLogEntry ));
		ret.put("state",  new net.bluemind.core.task.api.gwt.serder.TaskStatusStateGwtSerDer().serialize( o.state ));
		ret.put("result",  GwtSerDerUtils.STRING.serialize( o.result ));
	}
}