/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class RepairConfigGwtSerDer implements GwtSerDer<net.bluemind.directory.api.RepairConfig> {

	public RepairConfigGwtSerDer( ) {
	}

	@Override
	public net.bluemind.directory.api.RepairConfig deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.directory.api.RepairConfig ret = new net.bluemind.directory.api.RepairConfig();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.directory.api.RepairConfig ret, JSONObject json) {

		JSONValue opIdentifiersJSON = json.get("opIdentifiers");
		ret.opIdentifiers =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(opIdentifiersJSON);
		JSONValue dryJSON = json.get("dry");
		ret.dry =  GwtSerDerUtils.BOOLEAN.deserialize(dryJSON);
		JSONValue logToCoreLogJSON = json.get("logToCoreLog");
		ret.logToCoreLog =  GwtSerDerUtils.BOOLEAN.deserialize(logToCoreLogJSON);
		JSONValue verboseJSON = json.get("verbose");
		ret.verbose =  GwtSerDerUtils.BOOLEAN.deserialize(verboseJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.directory.api.RepairConfig o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.directory.api.RepairConfig o, JSONObject ret) {

		ret.put("opIdentifiers",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.opIdentifiers ));
		ret.put("dry",  GwtSerDerUtils.BOOLEAN.serialize( o.dry ));
		ret.put("logToCoreLog",  GwtSerDerUtils.BOOLEAN.serialize( o.logToCoreLog ));
		ret.put("verbose",  GwtSerDerUtils.BOOLEAN.serialize( o.verbose ));
	}
}