/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class DirEntryMaintenanceSockJsEndpoint implements net.bluemind.directory.api.IDirEntryMaintenanceAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public DirEntryMaintenanceSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/directory/{domain}/{entryUid}/mgmt";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domain}",pathVars[0]);
				uri_ = uri_.replace("{entryUid}",pathVars[1]);
		
		baseUri = uri_;
	}

	public DirEntryMaintenanceSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void getAvailableOperations(final AsyncHandler<List<net.bluemind.directory.api.MaintenanceOperation>> handler) {
		String postUri = "/_maintenance";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.directory.api.MaintenanceOperation>>(handler) {
					@Override
			protected List<net.bluemind.directory.api.MaintenanceOperation> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.directory.api.gwt.serder.MaintenanceOperationGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void repair(net.bluemind.directory.api.RepairConfig config, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/_maintenance/repair";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.directory.api.gwt.serder.RepairConfigGwtSerDer().serialize( config);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.directory.api.IDirEntryMaintenancePromise promiseApi() {
		return new DirEntryMaintenanceEndpointPromise(this);
	}

}
