/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class LoginResponseGwtSerDer implements GwtSerDer<net.bluemind.authentication.api.LoginResponse> {

	public LoginResponseGwtSerDer( ) {
	}

	@Override
	public net.bluemind.authentication.api.LoginResponse deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.authentication.api.LoginResponse ret = new net.bluemind.authentication.api.LoginResponse();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.authentication.api.LoginResponse ret, JSONObject json) {

		JSONValue statusJSON = json.get("status");
		ret.status =  new net.bluemind.authentication.api.gwt.serder.LoginResponseStatusGwtSerDer().deserialize(statusJSON);
		JSONValue messageJSON = json.get("message");
		ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		JSONValue authKeyJSON = json.get("authKey");
		ret.authKey =  GwtSerDerUtils.STRING.deserialize(authKeyJSON);
		JSONValue latdJSON = json.get("latd");
		ret.latd =  GwtSerDerUtils.STRING.deserialize(latdJSON);
		JSONValue authUserJSON = json.get("authUser");
		ret.authUser =  new net.bluemind.authentication.api.gwt.serder.AuthUserGwtSerDer().deserialize(authUserJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.authentication.api.LoginResponse o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.authentication.api.LoginResponse o, JSONObject ret) {

		ret.put("status",  new net.bluemind.authentication.api.gwt.serder.LoginResponseStatusGwtSerDer().serialize( o.status ));
		ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		ret.put("authKey",  GwtSerDerUtils.STRING.serialize( o.authKey ));
		ret.put("latd",  GwtSerDerUtils.STRING.serialize( o.latd ));
		ret.put("authUser",  new net.bluemind.authentication.api.gwt.serder.AuthUserGwtSerDer().serialize( o.authUser ));
	}
}