/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class APIKeyGwtSerDer implements GwtSerDer<net.bluemind.authentication.api.APIKey> {

	public APIKeyGwtSerDer( ) {
	}

	@Override
	public net.bluemind.authentication.api.APIKey deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.authentication.api.APIKey ret = new net.bluemind.authentication.api.APIKey();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.authentication.api.APIKey ret, JSONObject json) {

		JSONValue sidJSON = json.get("sid");
		ret.sid =  GwtSerDerUtils.STRING.deserialize(sidJSON);
		JSONValue displayNameJSON = json.get("displayName");
		ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		JSONValue domainUidJSON = json.get("domainUid");
		ret.domainUid =  GwtSerDerUtils.STRING.deserialize(domainUidJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.authentication.api.APIKey o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.authentication.api.APIKey o, JSONObject ret) {

		ret.put("sid",  GwtSerDerUtils.STRING.serialize( o.sid ));
		ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		ret.put("domainUid",  GwtSerDerUtils.STRING.serialize( o.domainUid ));
	}
}