/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.authentication.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsAccessTokenInfoTokenStatus extends JavaScriptObject {

	protected JsAccessTokenInfoTokenStatus() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsAccessTokenInfoTokenStatus NO_TOKEN_NEEDED()
	/*-{
		return "NO_TOKEN_NEEDED";
	}-*/;

	public static final native JsAccessTokenInfoTokenStatus TOKEN_OK()
	/*-{
		return "TOKEN_OK";
	}-*/;

	public static final native JsAccessTokenInfoTokenStatus TOKEN_NOT_VALID()
	/*-{
		return "TOKEN_NOT_VALID";
	}-*/;

	public static final JsAccessTokenInfoTokenStatus create(net.bluemind.authentication.api.AccessTokenInfo.TokenStatus value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case NO_TOKEN_NEEDED:
				return NO_TOKEN_NEEDED();
			case TOKEN_OK:
				return TOKEN_OK();
			case TOKEN_NOT_VALID:
				return TOKEN_NOT_VALID();
			default:
				return null;
			}
		}
	}
}