/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class UserAccessTokenEndpointPromise implements net.bluemind.authentication.api.IUserAccessTokenPromise {

	private net.bluemind.authentication.api.IUserAccessTokenAsync impl;

	public UserAccessTokenEndpointPromise(net.bluemind.authentication.api.IUserAccessTokenAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<net.bluemind.authentication.api.AccessTokenInfo> authCodeReceived(String state ,  String code  ) {
		
		CompletableFuture<net.bluemind.authentication.api.AccessTokenInfo> ret = new CompletableFuture<net.bluemind.authentication.api.AccessTokenInfo>();
		AsyncHandler<net.bluemind.authentication.api.AccessTokenInfo> handler = new AsyncHandler<net.bluemind.authentication.api.AccessTokenInfo>() {
			public void success(net.bluemind.authentication.api.AccessTokenInfo value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.authCodeReceived(state, code,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.authentication.api.AccessTokenInfo> getTokenInfo(String external_system ,  String baseUrl  ) {
		
		CompletableFuture<net.bluemind.authentication.api.AccessTokenInfo> ret = new CompletableFuture<net.bluemind.authentication.api.AccessTokenInfo>();
		AsyncHandler<net.bluemind.authentication.api.AccessTokenInfo> handler = new AsyncHandler<net.bluemind.authentication.api.AccessTokenInfo>() {
			public void success(net.bluemind.authentication.api.AccessTokenInfo value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getTokenInfo(external_system, baseUrl,  handler);
		return ret;
	}

}
