/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class APIKeysEndpointPromise implements net.bluemind.authentication.api.IAPIKeysPromise {

	private net.bluemind.authentication.api.IAPIKeysAsync impl;

	public APIKeysEndpointPromise(net.bluemind.authentication.api.IAPIKeysAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<net.bluemind.authentication.api.APIKey> store(String key ,  String displayName  ) {
		
		CompletableFuture<net.bluemind.authentication.api.APIKey> ret = new CompletableFuture<net.bluemind.authentication.api.APIKey>();
		AsyncHandler<net.bluemind.authentication.api.APIKey> handler = new AsyncHandler<net.bluemind.authentication.api.APIKey>() {
			public void success(net.bluemind.authentication.api.APIKey value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.store(key, displayName,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.authentication.api.APIKey>> list() {
		
		CompletableFuture<List<net.bluemind.authentication.api.APIKey>> ret = new CompletableFuture<List<net.bluemind.authentication.api.APIKey>>();
		AsyncHandler<List<net.bluemind.authentication.api.APIKey>> handler = new AsyncHandler<List<net.bluemind.authentication.api.APIKey>>() {
			public void success(List<net.bluemind.authentication.api.APIKey> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.list( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String sid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(sid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.authentication.api.APIKey> get(String sid  ) {
		
		CompletableFuture<net.bluemind.authentication.api.APIKey> ret = new CompletableFuture<net.bluemind.authentication.api.APIKey>();
		AsyncHandler<net.bluemind.authentication.api.APIKey> handler = new AsyncHandler<net.bluemind.authentication.api.APIKey>() {
			public void success(net.bluemind.authentication.api.APIKey value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.get(sid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.authentication.api.APIKey> create(String displayName  ) {
		
		CompletableFuture<net.bluemind.authentication.api.APIKey> ret = new CompletableFuture<net.bluemind.authentication.api.APIKey>();
		AsyncHandler<net.bluemind.authentication.api.APIKey> handler = new AsyncHandler<net.bluemind.authentication.api.APIKey>() {
			public void success(net.bluemind.authentication.api.APIKey value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(displayName,  handler);
		return ret;
	}

}
