/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SimpleShardStatsGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.SimpleShardStats> {

	public SimpleShardStatsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.SimpleShardStats deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.SimpleShardStats ret = new net.bluemind.mailbox.api.SimpleShardStats();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.SimpleShardStats ret, JSONObject json) {

		JSONValue indexNameJSON = json.get("indexName");
		ret.indexName =  GwtSerDerUtils.STRING.deserialize(indexNameJSON);
		JSONValue mailboxesJSON = json.get("mailboxes");
		ret.mailboxes =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(mailboxesJSON);
		JSONValue docCountJSON = json.get("docCount");
		ret.docCount =  GwtSerDerUtils.LONG.deserialize(docCountJSON);
		JSONValue deletedCountJSON = json.get("deletedCount");
		ret.deletedCount =  GwtSerDerUtils.LONG.deserialize(deletedCountJSON);
		JSONValue externalRefreshCountJSON = json.get("externalRefreshCount");
		ret.externalRefreshCount =  GwtSerDerUtils.LONG.deserialize(externalRefreshCountJSON);
		JSONValue externalRefreshDurationJSON = json.get("externalRefreshDuration");
		ret.externalRefreshDuration =  GwtSerDerUtils.LONG.deserialize(externalRefreshDurationJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.LONG.deserialize(sizeJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.SimpleShardStats o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.SimpleShardStats o, JSONObject ret) {

		ret.put("indexName",  GwtSerDerUtils.STRING.serialize( o.indexName ));
		ret.put("mailboxes",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.mailboxes ));
		ret.put("docCount",  GwtSerDerUtils.LONG.serialize( o.docCount ));
		ret.put("deletedCount",  GwtSerDerUtils.LONG.serialize( o.deletedCount ));
		ret.put("externalRefreshCount",  GwtSerDerUtils.LONG.serialize( o.externalRefreshCount ));
		ret.put("externalRefreshDuration",  GwtSerDerUtils.LONG.serialize( o.externalRefreshDuration ));
		ret.put("size",  GwtSerDerUtils.LONG.serialize( o.size ));
	}
}