/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ShardStatsGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.ShardStats> {

    private net.bluemind.mailbox.api.gwt.serder.SimpleShardStatsGwtSerDer parent = new  net.bluemind.mailbox.api.gwt.serder.SimpleShardStatsGwtSerDer(); 
	public ShardStatsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.ShardStats deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.ShardStats ret = new net.bluemind.mailbox.api.ShardStats();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.ShardStats ret, JSONObject json) {
		parent.deserializeTo( ret, json);

		JSONValue topMailboxJSON = json.get("topMailbox");
		ret.topMailbox =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.gwt.serder.ShardStatsMailboxStatsGwtSerDer()).deserialize(topMailboxJSON);
		JSONValue stateJSON = json.get("state");
		ret.state =  new net.bluemind.mailbox.api.gwt.serder.ShardStatsStateGwtSerDer().deserialize(stateJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.ShardStats o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.ShardStats o, JSONObject ret) {
		parent.serializeTo( o, ret);

		ret.put("topMailbox",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.gwt.serder.ShardStatsMailboxStatsGwtSerDer()).serialize( o.topMailbox ));
		ret.put("state",  new net.bluemind.mailbox.api.gwt.serder.ShardStatsStateGwtSerDer().serialize( o.state ));
	}
}