/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterRuleGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.MailFilter.Rule> {

	public MailFilterRuleGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.MailFilter.Rule deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.MailFilter.Rule ret = new net.bluemind.mailbox.api.MailFilter.Rule();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.MailFilter.Rule ret, JSONObject json) {

		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue criteriaJSON = json.get("criteria");
		ret.criteria =  GwtSerDerUtils.STRING.deserialize(criteriaJSON);
		JSONValue starJSON = json.get("star");
		ret.star =  GwtSerDerUtils.BOOLEAN.deserialize(starJSON);
		JSONValue readJSON = json.get("read");
		ret.read =  GwtSerDerUtils.BOOLEAN.deserialize(readJSON);
		JSONValue deleteJSON = json.get("delete");
		ret.delete =  GwtSerDerUtils.BOOLEAN.deserialize(deleteJSON);
		JSONValue discardJSON = json.get("discard");
		ret.discard =  GwtSerDerUtils.BOOLEAN.deserialize(discardJSON);
		JSONValue forwardJSON = json.get("forward");
		ret.forward =  new net.bluemind.mailbox.api.gwt.serder.MailFilterForwardingGwtSerDer().deserialize(forwardJSON);
		JSONValue deliverJSON = json.get("deliver");
		ret.deliver =  GwtSerDerUtils.STRING.deserialize(deliverJSON);
		JSONValue activeJSON = json.get("active");
		ret.active =  GwtSerDerUtils.BOOLEAN.deserialize(activeJSON);
		JSONValue stopJSON = json.get("stop");
		ret.stop =  GwtSerDerUtils.BOOLEAN.deserialize(stopJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.MailFilter.Rule o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.MailFilter.Rule o, JSONObject ret) {

		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("criteria",  GwtSerDerUtils.STRING.serialize( o.criteria ));
		ret.put("star",  GwtSerDerUtils.BOOLEAN.serialize( o.star ));
		ret.put("read",  GwtSerDerUtils.BOOLEAN.serialize( o.read ));
		ret.put("delete",  GwtSerDerUtils.BOOLEAN.serialize( o.delete ));
		ret.put("discard",  GwtSerDerUtils.BOOLEAN.serialize( o.discard ));
		ret.put("forward",  new net.bluemind.mailbox.api.gwt.serder.MailFilterForwardingGwtSerDer().serialize( o.forward ));
		ret.put("deliver",  GwtSerDerUtils.STRING.serialize( o.deliver ));
		ret.put("active",  GwtSerDerUtils.BOOLEAN.serialize( o.active ));
		ret.put("stop",  GwtSerDerUtils.BOOLEAN.serialize( o.stop ));
	}
}