/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class MailboxesEndpointPromise implements net.bluemind.mailbox.api.IMailboxesPromise {

	private net.bluemind.mailbox.api.IMailboxesAsync impl;

	public MailboxesEndpointPromise(net.bluemind.mailbox.api.IMailboxesAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<net.bluemind.mailbox.api.MailboxConfig> getMailboxConfig(String uid  ) {
		
		CompletableFuture<net.bluemind.mailbox.api.MailboxConfig> ret = new CompletableFuture<net.bluemind.mailbox.api.MailboxConfig>();
		AsyncHandler<net.bluemind.mailbox.api.MailboxConfig> handler = new AsyncHandler<net.bluemind.mailbox.api.MailboxConfig>() {
			public void success(net.bluemind.mailbox.api.MailboxConfig value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxConfig(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.mailbox.api.Mailbox mailbox  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, mailbox,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> byName(String name  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byName(name,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setMailboxFilter(String mailboxUid ,  net.bluemind.mailbox.api.MailFilter filter  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setMailboxFilter(mailboxUid, filter,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Integer> getUnreadMessagesCount() {
		
		CompletableFuture<Integer> ret = new CompletableFuture<Integer>();
		AsyncHandler<Integer> handler = new AsyncHandler<Integer>() {
			public void success(Integer value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getUnreadMessagesCount( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> listUids() {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.listUids( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setMailboxAccessControlList(String mailboxUid ,  List<net.bluemind.core.container.model.acl.AccessControlEntry> accessControlEntries  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setMailboxAccessControlList(mailboxUid, accessControlEntries,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> byEmail(String email  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byEmail(email,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.mailbox.api.Mailbox mailbox  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, mailbox,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> byRouting(net.bluemind.mailbox.api.Mailbox.Routing email  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byRouting(email,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> checkAll() {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.checkAll( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> multipleGet(List<String> uids  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGet(uids,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> checkAndRepair(String uid  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.checkAndRepair(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.MailFilter> getMailboxFilter(String mailboxUid  ) {
		
		CompletableFuture<net.bluemind.mailbox.api.MailFilter> ret = new CompletableFuture<net.bluemind.mailbox.api.MailFilter>();
		AsyncHandler<net.bluemind.mailbox.api.MailFilter> handler = new AsyncHandler<net.bluemind.mailbox.api.MailFilter>() {
			public void success(net.bluemind.mailbox.api.MailFilter value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxFilter(mailboxUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.acl.AccessControlEntry>> getMailboxAccessControlList(String mailboxUid  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.acl.AccessControlEntry>> ret = new CompletableFuture<List<net.bluemind.core.container.model.acl.AccessControlEntry>>();
		AsyncHandler<List<net.bluemind.core.container.model.acl.AccessControlEntry>> handler = new AsyncHandler<List<net.bluemind.core.container.model.acl.AccessControlEntry>>() {
			public void success(List<net.bluemind.core.container.model.acl.AccessControlEntry> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxAccessControlList(mailboxUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> check(String uid  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.check(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> list() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.list( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setDomainFilter(net.bluemind.mailbox.api.MailFilter filter  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setDomainFilter(filter,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.MailboxQuota> getMailboxQuota(String uid  ) {
		
		CompletableFuture<net.bluemind.mailbox.api.MailboxQuota> ret = new CompletableFuture<net.bluemind.mailbox.api.MailboxQuota>();
		AsyncHandler<net.bluemind.mailbox.api.MailboxQuota> handler = new AsyncHandler<net.bluemind.mailbox.api.MailboxQuota>() {
			public void success(net.bluemind.mailbox.api.MailboxQuota value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxQuota(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.MailFilter> getDomainFilter() {
		
		CompletableFuture<net.bluemind.mailbox.api.MailFilter> ret = new CompletableFuture<net.bluemind.mailbox.api.MailFilter>();
		AsyncHandler<net.bluemind.mailbox.api.MailFilter> handler = new AsyncHandler<net.bluemind.mailbox.api.MailFilter>() {
			public void success(net.bluemind.mailbox.api.MailFilter value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getDomainFilter( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> byType(net.bluemind.mailbox.api.Mailbox.Type email  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byType(email,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> checkAndRepairAll() {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.checkAndRepairAll( handler);
		return ret;
	}

}
