/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.notes.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VNoteQueryGwtSerDer implements GwtSerDer<net.bluemind.notes.api.VNoteQuery> {

	public VNoteQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.notes.api.VNoteQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.notes.api.VNoteQuery ret = new net.bluemind.notes.api.VNoteQuery();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.notes.api.VNoteQuery ret, JSONObject json) {

		JSONValue fromJSON = json.get("from");
		ret.from =  GwtSerDerUtils.INT.deserialize(fromJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		JSONValue queryJSON = json.get("query");
		ret.query =  GwtSerDerUtils.STRING.deserialize(queryJSON);
		JSONValue escapeQueryJSON = json.get("escapeQuery");
		ret.escapeQuery =  GwtSerDerUtils.BOOLEAN.deserialize(escapeQueryJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.notes.api.VNoteQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.notes.api.VNoteQuery o, JSONObject ret) {

		ret.put("from",  GwtSerDerUtils.INT.serialize( o.from ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		ret.put("query",  GwtSerDerUtils.STRING.serialize( o.query ));
		ret.put("escapeQuery",  GwtSerDerUtils.BOOLEAN.serialize( o.escapeQuery ));
	}
}