/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.notes.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class NotesSockJsEndpoint implements net.bluemind.notes.api.INotesAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public NotesSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/notes";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public NotesSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void search(net.bluemind.notes.api.VNotesQuery query, final AsyncHandler<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.notes.api.VNote>>> handler) {
		String postUri = "/_search";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.notes.api.gwt.serder.VNotesQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.notes.api.VNote>>>(handler) {
					@Override
			protected List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.notes.api.VNote>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemContainerValueGwtSerDer<>(new net.bluemind.notes.api.gwt.serder.VNoteGwtSerDer())).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void create(String uid, net.bluemind.core.container.model.ContainerDescriptor descriptor, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.ContainerDescriptorGwtSerDer().serialize( descriptor);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void delete(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}

	public net.bluemind.notes.api.INotesPromise promiseApi() {
		return new NotesEndpointPromise(this);
	}

}
