/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.identity.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class IdentityGwtSerDer implements GwtSerDer<net.bluemind.mailbox.identity.api.Identity> {

	public IdentityGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.identity.api.Identity deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.identity.api.Identity ret = new net.bluemind.mailbox.identity.api.Identity();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.identity.api.Identity ret, JSONObject json) {

		JSONValue emailJSON = json.get("email");
		ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
		JSONValue formatJSON = json.get("format");
		ret.format =  new net.bluemind.mailbox.identity.api.gwt.serder.SignatureFormatGwtSerDer().deserialize(formatJSON);
		JSONValue signatureJSON = json.get("signature");
		ret.signature =  GwtSerDerUtils.STRING.deserialize(signatureJSON);
		JSONValue displaynameJSON = json.get("displayname");
		ret.displayname =  GwtSerDerUtils.STRING.deserialize(displaynameJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue isDefaultJSON = json.get("isDefault");
		ret.isDefault =  GwtSerDerUtils.BOOLEAN.deserialize(isDefaultJSON);
		JSONValue sentFolderJSON = json.get("sentFolder");
		ret.sentFolder =  GwtSerDerUtils.STRING.deserialize(sentFolderJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.mailbox.identity.api.Identity o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.identity.api.Identity o, JSONObject ret) {

		ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
		ret.put("format",  new net.bluemind.mailbox.identity.api.gwt.serder.SignatureFormatGwtSerDer().serialize( o.format ));
		ret.put("signature",  GwtSerDerUtils.STRING.serialize( o.signature ));
		ret.put("displayname",  GwtSerDerUtils.STRING.serialize( o.displayname ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("isDefault",  GwtSerDerUtils.BOOLEAN.serialize( o.isDefault ));
		ret.put("sentFolder",  GwtSerDerUtils.STRING.serialize( o.sentFolder ));
	}
}