/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.system.api.hot.upgrade.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsHotUpgradeTask extends JavaScriptObject {

	protected JsHotUpgradeTask() {}

	public final native int getId()
	/*-{
	return this["id"];
	}-*/;

	public final native void setId(int id)
	/*-{
       this["id"] = id;
	}-*/;

	public final native String getOperation()
	/*-{
	return this["operation"];
	}-*/;

	public final native void setOperation(String operation)
	/*-{
       this["operation"] = operation;
	}-*/;

	public final native String getParameters()
	/*-{
	return this["parameters"];
	}-*/;

	public final native void setParameters(String parameters)
	/*-{
       this["parameters"] = parameters;
	}-*/;

	public final native net.bluemind.system.api.hot.upgrade.gwt.js.JsHotUpgradeTaskStatus getStatus()
	/*-{
	return this["status"];
	}-*/;

	public final native void setStatus(net.bluemind.system.api.hot.upgrade.gwt.js.JsHotUpgradeTaskStatus status)
	/*-{
       this["status"] = status;
	}-*/;

	public final native int getFailure()
	/*-{
	return this["failure"];
	}-*/;

	public final native void setFailure(int failure)
	/*-{
       this["failure"] = failure;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getCreatedAt()
	/*-{
       if(this["createdAt"]) {
          return new Date(this["createdAt"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setCreatedAt(com.google.gwt.core.client.JsDate createdAt)
	/*-{
       this["createdAt"] =  ( createdAt != null) ? createdAt.getTime() : null;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getUpdatedAt()
	/*-{
       if(this["updatedAt"]) {
          return new Date(this["updatedAt"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setUpdatedAt(com.google.gwt.core.client.JsDate updatedAt)
	/*-{
       this["updatedAt"] =  ( updatedAt != null) ? updatedAt.getTime() : null;
	}-*/;

	public final native net.bluemind.system.api.hot.upgrade.gwt.js.JsHotUpgradeTaskExecutionMode getExecutionMode()
	/*-{
	return this["executionMode"];
	}-*/;

	public final native void setExecutionMode(net.bluemind.system.api.hot.upgrade.gwt.js.JsHotUpgradeTaskExecutionMode executionMode)
	/*-{
       this["executionMode"] = executionMode;
	}-*/;

	public final native int getRetryCount()
	/*-{
	return this["retryCount"];
	}-*/;

	public final native void setRetryCount(int retryCount)
	/*-{
       this["retryCount"] = retryCount;
	}-*/;

	public final native int getRetryDelaySeconds()
	/*-{
	return this["retryDelaySeconds"];
	}-*/;

	public final native void setRetryDelaySeconds(int retryDelaySeconds)
	/*-{
       this["retryDelaySeconds"] = retryDelaySeconds;
	}-*/;

	public final native boolean getReportFailure()
	/*-{
	return this["reportFailure"];
	}-*/;

	public final native void setReportFailure(boolean reportFailure)
	/*-{
       this["reportFailure"] = reportFailure;
	}-*/;

	public static native  JsHotUpgradeTask create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}