/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SubscriptionInformationsInstallationIndicatorGwtSerDer implements GwtSerDer<net.bluemind.system.api.SubscriptionInformations.InstallationIndicator> {

	public SubscriptionInformationsInstallationIndicatorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.SubscriptionInformations.InstallationIndicator deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.SubscriptionInformations.InstallationIndicator ret = new net.bluemind.system.api.SubscriptionInformations.InstallationIndicator();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.SubscriptionInformations.InstallationIndicator ret, JSONObject json) {

		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.system.api.gwt.serder.SubscriptionInformationsInstallationIndicatorKindGwtSerDer().deserialize(kindJSON);
		JSONValue maxValueJSON = json.get("maxValue");
		ret.maxValue =  GwtSerDerUtils.INT.deserialize(maxValueJSON);
		JSONValue currentValueJSON = json.get("currentValue");
		ret.currentValue =  GwtSerDerUtils.INT.deserialize(currentValueJSON);
		JSONValue expirationJSON = json.get("expiration");
		ret.expiration =  GwtSerDerUtils.DATE.deserialize(expirationJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.system.api.SubscriptionInformations.InstallationIndicator o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.SubscriptionInformations.InstallationIndicator o, JSONObject ret) {

		ret.put("kind",  new net.bluemind.system.api.gwt.serder.SubscriptionInformationsInstallationIndicatorKindGwtSerDer().serialize( o.kind ));
		ret.put("maxValue",  GwtSerDerUtils.INT.serialize( o.maxValue ));
		ret.put("currentValue",  GwtSerDerUtils.INT.serialize( o.currentValue ));
		ret.put("expiration",  GwtSerDerUtils.DATE.serialize( o.expiration ));
	}
}