/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class InstallationVersionGwtSerDer implements GwtSerDer<net.bluemind.system.api.InstallationVersion> {

	public InstallationVersionGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.InstallationVersion deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.InstallationVersion ret = new net.bluemind.system.api.InstallationVersion();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.InstallationVersion ret, JSONObject json) {

		JSONValue databaseVersionJSON = json.get("databaseVersion");
		ret.databaseVersion =  GwtSerDerUtils.STRING.deserialize(databaseVersionJSON);
		JSONValue softwareVersionJSON = json.get("softwareVersion");
		ret.softwareVersion =  GwtSerDerUtils.STRING.deserialize(softwareVersionJSON);
		JSONValue versionNameJSON = json.get("versionName");
		ret.versionName =  GwtSerDerUtils.STRING.deserialize(versionNameJSON);
		JSONValue needsUpgradeJSON = json.get("needsUpgrade");
		ret.needsUpgrade =  GwtSerDerUtils.BOOLEAN.deserialize(needsUpgradeJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.system.api.InstallationVersion o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.InstallationVersion o, JSONObject ret) {

		ret.put("databaseVersion",  GwtSerDerUtils.STRING.serialize( o.databaseVersion ));
		ret.put("softwareVersion",  GwtSerDerUtils.STRING.serialize( o.softwareVersion ));
		ret.put("versionName",  GwtSerDerUtils.STRING.serialize( o.versionName ));
		ret.put("needsUpgrade",  GwtSerDerUtils.BOOLEAN.serialize( o.needsUpgrade ));
	}
}