/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CertDataGwtSerDer implements GwtSerDer<net.bluemind.system.api.CertData> {

	public CertDataGwtSerDer( ) {
	}

	@Override
	public net.bluemind.system.api.CertData deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.system.api.CertData ret = new net.bluemind.system.api.CertData();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.system.api.CertData ret, JSONObject json) {

		JSONValue sslCertificateEngineJSON = json.get("sslCertificateEngine");
		ret.sslCertificateEngine =  new net.bluemind.system.api.gwt.serder.CertDataCertificateDomainEngineGwtSerDer().deserialize(sslCertificateEngineJSON);
		JSONValue certificateAuthorityJSON = json.get("certificateAuthority");
		ret.certificateAuthority =  GwtSerDerUtils.STRING.deserialize(certificateAuthorityJSON);
		JSONValue certificateJSON = json.get("certificate");
		ret.certificate =  GwtSerDerUtils.STRING.deserialize(certificateJSON);
		JSONValue privateKeyJSON = json.get("privateKey");
		ret.privateKey =  GwtSerDerUtils.STRING.deserialize(privateKeyJSON);
		JSONValue domainUidJSON = json.get("domainUid");
		ret.domainUid =  GwtSerDerUtils.STRING.deserialize(domainUidJSON);
		JSONValue emailJSON = json.get("email");
		ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.system.api.CertData o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.system.api.CertData o, JSONObject ret) {

		ret.put("sslCertificateEngine",  new net.bluemind.system.api.gwt.serder.CertDataCertificateDomainEngineGwtSerDer().serialize( o.sslCertificateEngine ));
		ret.put("certificateAuthority",  GwtSerDerUtils.STRING.serialize( o.certificateAuthority ));
		ret.put("certificate",  GwtSerDerUtils.STRING.serialize( o.certificate ));
		ret.put("privateKey",  GwtSerDerUtils.STRING.serialize( o.privateKey ));
		ret.put("domainUid",  GwtSerDerUtils.STRING.serialize( o.domainUid ));
		ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
	}
}