/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.system.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsSubscriptionInformationsKind extends JavaScriptObject {

	protected JsSubscriptionInformationsKind() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsSubscriptionInformationsKind NONE()
	/*-{
		return "NONE";
	}-*/;

	public static final native JsSubscriptionInformationsKind FREE()
	/*-{
		return "FREE";
	}-*/;

	public static final native JsSubscriptionInformationsKind TRIAL()
	/*-{
		return "TRIAL";
	}-*/;

	public static final native JsSubscriptionInformationsKind PROD()
	/*-{
		return "PROD";
	}-*/;

	public static final native JsSubscriptionInformationsKind HOST()
	/*-{
		return "HOST";
	}-*/;

	public static final JsSubscriptionInformationsKind create(net.bluemind.system.api.SubscriptionInformations.Kind value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case NONE:
				return NONE();
			case FREE:
				return FREE();
			case TRIAL:
				return TRIAL();
			case PROD:
				return PROD();
			case HOST:
				return HOST();
			default:
				return null;
			}
		}
	}
}