/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.group.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class GroupEndpointPromise implements net.bluemind.group.api.IGroupPromise {

	private net.bluemind.group.api.IGroupAsync impl;

	public GroupEndpointPromise(net.bluemind.group.api.IGroupAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> setExtId(String uid ,  String arg1  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setExtId(uid, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> memberOf(String uid  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.memberOf(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> memberOfGroups(String uid  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.memberOfGroups(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.group.api.Member>> getExpandedUserMembers(String uid  ) {
		
		CompletableFuture<List<net.bluemind.group.api.Member>> ret = new CompletableFuture<List<net.bluemind.group.api.Member>>();
		AsyncHandler<List<net.bluemind.group.api.Member>> handler = new AsyncHandler<List<net.bluemind.group.api.Member>>() {
			public void success(List<net.bluemind.group.api.Member> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getExpandedUserMembers(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> allUids() {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allUids( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.group.api.Group group  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, group,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> byName(String name  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byName(name,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> delete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> remove(String uid ,  List<net.bluemind.group.api.Member> members  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.remove(uid, members,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> getParents(String uid  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getParents(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> search(net.bluemind.group.api.GroupSearchQuery query  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.search(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.group.api.Member>> getExpandedMembers(String uid  ) {
		
		CompletableFuture<List<net.bluemind.group.api.Member>> ret = new CompletableFuture<List<net.bluemind.group.api.Member>>();
		AsyncHandler<List<net.bluemind.group.api.Member>> handler = new AsyncHandler<List<net.bluemind.group.api.Member>>() {
			public void success(List<net.bluemind.group.api.Member> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getExpandedMembers(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> byEmail(String email  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byEmail(email,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.group.api.Group group  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, group,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setRoles(String uid ,  Set<String> roles  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setRoles(uid, roles,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<String>> getRoles(String uid  ) {
		
		CompletableFuture<Set<String>> ret = new CompletableFuture<Set<String>>();
		AsyncHandler<Set<String>> handler = new AsyncHandler<Set<String>>() {
			public void success(Set<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRoles(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> add(String uid ,  List<net.bluemind.group.api.Member> members  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.add(uid, members,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> getByExtId(String extid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getByExtId(extid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> touch(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.touch(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<String>> getGroupsWithRoles(List<String> roles  ) {
		
		CompletableFuture<Set<String>> ret = new CompletableFuture<Set<String>>();
		AsyncHandler<Set<String>> handler = new AsyncHandler<Set<String>>() {
			public void success(Set<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getGroupsWithRoles(roles,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> createWithExtId(String uid ,  String extid ,  net.bluemind.group.api.Group group  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.createWithExtId(uid, extid, group,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.group.api.Member>> getMembers(String uid  ) {
		
		CompletableFuture<List<net.bluemind.group.api.Member>> ret = new CompletableFuture<List<net.bluemind.group.api.Member>>();
		AsyncHandler<List<net.bluemind.group.api.Member>> handler = new AsyncHandler<List<net.bluemind.group.api.Member>>() {
			public void success(List<net.bluemind.group.api.Member> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMembers(uid,  handler);
		return ret;
	}

}
