/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ListResultGwtSerDer<E> implements GwtSerDer<net.bluemind.core.api.ListResult<E>> {

	private GwtSerDer<E> paramSerDerE;

	public ListResultGwtSerDer(GwtSerDer<E> paramSerDerE ) {
		this.paramSerDerE = paramSerDerE;
	}

	@Override
	public net.bluemind.core.api.ListResult<E> deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.api.ListResult<E> ret = new net.bluemind.core.api.ListResult<E>();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.api.ListResult<E> ret, JSONObject json) {

		JSONValue valuesJSON = json.get("values");
		ret.values =  new GwtSerDerUtils.ListSerDer<>(paramSerDerE).deserialize(valuesJSON);
		JSONValue totalJSON = json.get("total");
		ret.total =  GwtSerDerUtils.LONG.deserialize(totalJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.api.ListResult<E> o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.api.ListResult<E> o, JSONObject ret) {

		ret.put("values",  new GwtSerDerUtils.ListSerDer<>(paramSerDerE).serialize( o.values ));
		ret.put("total",  GwtSerDerUtils.LONG.serialize( o.total ));
	}
}