/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ImportStatsGwtSerDer implements GwtSerDer<net.bluemind.core.api.ImportStats> {

	public ImportStatsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.api.ImportStats deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.api.ImportStats ret = new net.bluemind.core.api.ImportStats();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.api.ImportStats ret, JSONObject json) {

		JSONValue uidsJSON = json.get("uids");
		ret.uids =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(uidsJSON);
		JSONValue totalJSON = json.get("total");
		ret.total =  GwtSerDerUtils.INT.deserialize(totalJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.api.ImportStats o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.api.ImportStats o, JSONObject ret) {

		ret.put("uids",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.uids ));
		ret.put("total",  GwtSerDerUtils.INT.serialize( o.total ));
	}
}