/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.core.api.fault.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsErrorCode extends JavaScriptObject {

	protected JsErrorCode() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsErrorCode UNKNOWN()
	/*-{
		return "UNKNOWN";
	}-*/;

	public static final native JsErrorCode PERMISSION_DENIED()
	/*-{
		return "PERMISSION_DENIED";
	}-*/;

	public static final native JsErrorCode FAILURE()
	/*-{
		return "FAILURE";
	}-*/;

	public static final native JsErrorCode INVALID_ID()
	/*-{
		return "INVALID_ID";
	}-*/;

	public static final native JsErrorCode INVALID_PARAMETER()
	/*-{
		return "INVALID_PARAMETER";
	}-*/;

	public static final native JsErrorCode AUTHENTICATION_FAIL()
	/*-{
		return "AUTHENTICATION_FAIL";
	}-*/;

	public static final native JsErrorCode SQL_ERROR()
	/*-{
		return "SQL_ERROR";
	}-*/;

	public static final native JsErrorCode NOT_FOUND()
	/*-{
		return "NOT_FOUND";
	}-*/;

	public static final native JsErrorCode ALREADY_EXISTS()
	/*-{
		return "ALREADY_EXISTS";
	}-*/;

	public static final native JsErrorCode FORBIDDEN()
	/*-{
		return "FORBIDDEN";
	}-*/;

	public static final native JsErrorCode ENTITY_TOO_LARGE()
	/*-{
		return "ENTITY_TOO_LARGE";
	}-*/;

	public static final native JsErrorCode INVALID_QUERY()
	/*-{
		return "INVALID_QUERY";
	}-*/;

	public static final native JsErrorCode INVALID_XML_RECEIVED()
	/*-{
		return "INVALID_XML_RECEIVED";
	}-*/;

	public static final native JsErrorCode CHILD_GROUP_MUST_EXIST()
	/*-{
		return "CHILD_GROUP_MUST_EXIST";
	}-*/;

	public static final native JsErrorCode CANT_DELETE_MYSELF()
	/*-{
		return "CANT_DELETE_MYSELF";
	}-*/;

	public static final native JsErrorCode DELEGATION_RESTRICTION()
	/*-{
		return "DELEGATION_RESTRICTION";
	}-*/;

	public static final native JsErrorCode INVALID_PASSWORD()
	/*-{
		return "INVALID_PASSWORD";
	}-*/;

	public static final native JsErrorCode LOGIN_ALREADY_USED()
	/*-{
		return "LOGIN_ALREADY_USED";
	}-*/;

	public static final native JsErrorCode INVALID_LOGIN()
	/*-{
		return "INVALID_LOGIN";
	}-*/;

	public static final native JsErrorCode EMPTY_LASTNAME()
	/*-{
		return "EMPTY_LASTNAME";
	}-*/;

	public static final native JsErrorCode EMPTY_VACATION_MESSAGE()
	/*-{
		return "EMPTY_VACATION_MESSAGE";
	}-*/;

	public static final native JsErrorCode VACATION_WITHOUT_MAILBOX()
	/*-{
		return "VACATION_WITHOUT_MAILBOX";
	}-*/;

	public static final native JsErrorCode FORWARDING_WITHOUT_MAILBOX()
	/*-{
		return "FORWARDING_WITHOUT_MAILBOX";
	}-*/;

	public static final native JsErrorCode FORWARDING_INVALID_EMAIL()
	/*-{
		return "FORWARDING_INVALID_EMAIL";
	}-*/;

	public static final native JsErrorCode INVALID_MAIL_SERVER()
	/*-{
		return "INVALID_MAIL_SERVER";
	}-*/;

	public static final native JsErrorCode INVALID_GROUP_NAME()
	/*-{
		return "INVALID_GROUP_NAME";
	}-*/;

	public static final native JsErrorCode FORWARDING_TO_OWN_MAILBOX()
	/*-{
		return "FORWARDING_TO_OWN_MAILBOX";
	}-*/;

	public static final native JsErrorCode SAME_PARENT_AND_CHILD_GROUP()
	/*-{
		return "SAME_PARENT_AND_CHILD_GROUP";
	}-*/;

	public static final native JsErrorCode INCLUSION_GROUP_LOOP()
	/*-{
		return "INCLUSION_GROUP_LOOP";
	}-*/;

	public static final native JsErrorCode EMAIL_ALREADY_USED()
	/*-{
		return "EMAIL_ALREADY_USED";
	}-*/;

	public static final native JsErrorCode INVALID_EMAIL()
	/*-{
		return "INVALID_EMAIL";
	}-*/;

	public static final native JsErrorCode MAIL_QUOTA_OVER_DOMAIN_LIMIT()
	/*-{
		return "MAIL_QUOTA_OVER_DOMAIN_LIMIT";
	}-*/;

	public static final native JsErrorCode NOT_GLOBAL_ADMIN()
	/*-{
		return "NOT_GLOBAL_ADMIN";
	}-*/;

	public static final native JsErrorCode DOMAIN_NAME_ALREADY_USED()
	/*-{
		return "DOMAIN_NAME_ALREADY_USED";
	}-*/;

	public static final native JsErrorCode INVALID_MAILSHARE_NAME()
	/*-{
		return "INVALID_MAILSHARE_NAME";
	}-*/;

	public static final native JsErrorCode INVALID_RESOURCE_NAME()
	/*-{
		return "INVALID_RESOURCE_NAME";
	}-*/;

	public static final native JsErrorCode OLD_PASSWORD_WRONG()
	/*-{
		return "OLD_PASSWORD_WRONG";
	}-*/;

	public static final native JsErrorCode OLD_PASSWORD_SAME_AS_NEW()
	/*-{
		return "OLD_PASSWORD_SAME_AS_NEW";
	}-*/;

	public static final native JsErrorCode IP_ADDRESS_ALREADY_USED()
	/*-{
		return "IP_ADDRESS_ALREADY_USED";
	}-*/;

	public static final native JsErrorCode MBOX_RENAME_FAILED()
	/*-{
		return "MBOX_RENAME_FAILED";
	}-*/;

	public static final native JsErrorCode INVALID_HOST_NAME()
	/*-{
		return "INVALID_HOST_NAME";
	}-*/;

	public static final native JsErrorCode EMPTY_EVENT_TITLE()
	/*-{
		return "EMPTY_EVENT_TITLE";
	}-*/;

	public static final native JsErrorCode NO_DURATION_EVENT()
	/*-{
		return "NO_DURATION_EVENT";
	}-*/;

	public static final native JsErrorCode NO_EVENT_DATE()
	/*-{
		return "NO_EVENT_DATE";
	}-*/;

	public static final native JsErrorCode NO_EVENT_TYPE()
	/*-{
		return "NO_EVENT_TYPE";
	}-*/;

	public static final native JsErrorCode EVENT_PRIVACY_INVALID()
	/*-{
		return "EVENT_PRIVACY_INVALID";
	}-*/;

	public static final native JsErrorCode EVENT_ERROR()
	/*-{
		return "EVENT_ERROR";
	}-*/;

	public static final native JsErrorCode CALENDAR_AUTHORISATION_ERROR()
	/*-{
		return "CALENDAR_AUTHORISATION_ERROR";
	}-*/;

	public static final native JsErrorCode CONTACT_DOMAIN_FORBIDDEN()
	/*-{
		return "CONTACT_DOMAIN_FORBIDDEN";
	}-*/;

	public static final native JsErrorCode EVENT_ENDREPEAT_PRIOR_TO_EVENT_DATE()
	/*-{
		return "EVENT_ENDREPEAT_PRIOR_TO_EVENT_DATE";
	}-*/;

	public static final native JsErrorCode INVALID_DOMAIN_NAME()
	/*-{
		return "INVALID_DOMAIN_NAME";
	}-*/;

	public static final native JsErrorCode GROUP_NAME_ALREADY_USED()
	/*-{
		return "GROUP_NAME_ALREADY_USED";
	}-*/;

	public static final native JsErrorCode INVALID_VACATION_RANGE()
	/*-{
		return "INVALID_VACATION_RANGE";
	}-*/;

	public static final native JsErrorCode EMPTY_DLIST_LABEL()
	/*-{
		return "EMPTY_DLIST_LABEL";
	}-*/;

	public static final native JsErrorCode EMPTY_DLIST_FOLDER()
	/*-{
		return "EMPTY_DLIST_FOLDER";
	}-*/;

	public static final native JsErrorCode DLIST_LOOP()
	/*-{
		return "DLIST_LOOP";
	}-*/;

	public static final native JsErrorCode CANT_UPDATE_ACL_IMPLICIT_RIGHTS()
	/*-{
		return "CANT_UPDATE_ACL_IMPLICIT_RIGHTS";
	}-*/;

	public static final native JsErrorCode USER_SPLIT_REQUIRES_SPLIT_DOMAIN()
	/*-{
		return "USER_SPLIT_REQUIRES_SPLIT_DOMAIN";
	}-*/;

	public static final native JsErrorCode SLAVE_RELAY_REQUIRES_SPLIT_DOMAIN()
	/*-{
		return "SLAVE_RELAY_REQUIRES_SPLIT_DOMAIN";
	}-*/;

	public static final native JsErrorCode INVALID_USER_LDAP_FILTER()
	/*-{
		return "INVALID_USER_LDAP_FILTER";
	}-*/;

	public static final native JsErrorCode SEC_GROUP_RM()
	/*-{
		return "SEC_GROUP_RM";
	}-*/;

	public static final native JsErrorCode NOT_IN_GLOBAL_DOMAIN()
	/*-{
		return "NOT_IN_GLOBAL_DOMAIN";
	}-*/;

	public static final native JsErrorCode NO_BACKUP_SERVER_FOUND()
	/*-{
		return "NO_BACKUP_SERVER_FOUND";
	}-*/;

	public static final native JsErrorCode OPERATION_ALREADY_RUNNING()
	/*-{
		return "OPERATION_ALREADY_RUNNING";
	}-*/;

	public static final native JsErrorCode INVALID_AD_HOST_NAME()
	/*-{
		return "INVALID_AD_HOST_NAME";
	}-*/;

	public static final native JsErrorCode JOB_FINISHED()
	/*-{
		return "JOB_FINISHED";
	}-*/;

	public static final native JsErrorCode INVALID_LICENSE()
	/*-{
		return "INVALID_LICENSE";
	}-*/;

	public static final native JsErrorCode HSM_MISSING_POLICY()
	/*-{
		return "HSM_MISSING_POLICY";
	}-*/;

	public static final native JsErrorCode INCOMPATIBLE_SMTP_TAGS()
	/*-{
		return "INCOMPATIBLE_SMTP_TAGS";
	}-*/;

	public static final native JsErrorCode INVALID_MAILBOX_NAME()
	/*-{
		return "INVALID_MAILBOX_NAME";
	}-*/;

	public static final native JsErrorCode TAG_ALREADY_EXIST()
	/*-{
		return "TAG_ALREADY_EXIST";
	}-*/;

	public static final native JsErrorCode INVALID_LINKED_MAILSHARE()
	/*-{
		return "INVALID_LINKED_MAILSHARE";
	}-*/;

	public static final native JsErrorCode MAILSHARE_GROUP_LINKED()
	/*-{
		return "MAILSHARE_GROUP_LINKED";
	}-*/;

	public static final native JsErrorCode SERVER_NOT_FOUND()
	/*-{
		return "SERVER_NOT_FOUND";
	}-*/;

	public static final native JsErrorCode DEPRECATED()
	/*-{
		return "DEPRECATED";
	}-*/;

	public static final native JsErrorCode INVALID_GROUP_MEMBER()
	/*-{
		return "INVALID_GROUP_MEMBER";
	}-*/;

	public static final native JsErrorCode EMPTY_EVENT_ATTACHMENT_VALUE()
	/*-{
		return "EMPTY_EVENT_ATTACHMENT_VALUE";
	}-*/;

	public static final native JsErrorCode TIMEOUT()
	/*-{
		return "TIMEOUT";
	}-*/;

	public static final native JsErrorCode VERSION_HAS_CHANGED()
	/*-{
		return "VERSION_HAS_CHANGED";
	}-*/;

	public static final native JsErrorCode MULTIPLE_EVENT_COUNTERS()
	/*-{
		return "MULTIPLE_EVENT_COUNTERS";
	}-*/;

	public static final native JsErrorCode EVENT_ACCEPTS_NO_COUNTERS()
	/*-{
		return "EVENT_ACCEPTS_NO_COUNTERS";
	}-*/;

	public static final native JsErrorCode EVENT_WEEKDAY_INVALID()
	/*-{
		return "EVENT_WEEKDAY_INVALID";
	}-*/;

	public static final native JsErrorCode EVENT_DUPLICATED_RECURID()
	/*-{
		return "EVENT_DUPLICATED_RECURID";
	}-*/;

	public static final native JsErrorCode MAX_ITEM_COUNT()
	/*-{
		return "MAX_ITEM_COUNT";
	}-*/;

	public static final JsErrorCode create(net.bluemind.core.api.fault.ErrorCode value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case UNKNOWN:
				return UNKNOWN();
			case PERMISSION_DENIED:
				return PERMISSION_DENIED();
			case FAILURE:
				return FAILURE();
			case INVALID_ID:
				return INVALID_ID();
			case INVALID_PARAMETER:
				return INVALID_PARAMETER();
			case AUTHENTICATION_FAIL:
				return AUTHENTICATION_FAIL();
			case SQL_ERROR:
				return SQL_ERROR();
			case NOT_FOUND:
				return NOT_FOUND();
			case ALREADY_EXISTS:
				return ALREADY_EXISTS();
			case FORBIDDEN:
				return FORBIDDEN();
			case ENTITY_TOO_LARGE:
				return ENTITY_TOO_LARGE();
			case INVALID_QUERY:
				return INVALID_QUERY();
			case INVALID_XML_RECEIVED:
				return INVALID_XML_RECEIVED();
			case CHILD_GROUP_MUST_EXIST:
				return CHILD_GROUP_MUST_EXIST();
			case CANT_DELETE_MYSELF:
				return CANT_DELETE_MYSELF();
			case DELEGATION_RESTRICTION:
				return DELEGATION_RESTRICTION();
			case INVALID_PASSWORD:
				return INVALID_PASSWORD();
			case LOGIN_ALREADY_USED:
				return LOGIN_ALREADY_USED();
			case INVALID_LOGIN:
				return INVALID_LOGIN();
			case EMPTY_LASTNAME:
				return EMPTY_LASTNAME();
			case EMPTY_VACATION_MESSAGE:
				return EMPTY_VACATION_MESSAGE();
			case VACATION_WITHOUT_MAILBOX:
				return VACATION_WITHOUT_MAILBOX();
			case FORWARDING_WITHOUT_MAILBOX:
				return FORWARDING_WITHOUT_MAILBOX();
			case FORWARDING_INVALID_EMAIL:
				return FORWARDING_INVALID_EMAIL();
			case INVALID_MAIL_SERVER:
				return INVALID_MAIL_SERVER();
			case INVALID_GROUP_NAME:
				return INVALID_GROUP_NAME();
			case FORWARDING_TO_OWN_MAILBOX:
				return FORWARDING_TO_OWN_MAILBOX();
			case SAME_PARENT_AND_CHILD_GROUP:
				return SAME_PARENT_AND_CHILD_GROUP();
			case INCLUSION_GROUP_LOOP:
				return INCLUSION_GROUP_LOOP();
			case EMAIL_ALREADY_USED:
				return EMAIL_ALREADY_USED();
			case INVALID_EMAIL:
				return INVALID_EMAIL();
			case MAIL_QUOTA_OVER_DOMAIN_LIMIT:
				return MAIL_QUOTA_OVER_DOMAIN_LIMIT();
			case NOT_GLOBAL_ADMIN:
				return NOT_GLOBAL_ADMIN();
			case DOMAIN_NAME_ALREADY_USED:
				return DOMAIN_NAME_ALREADY_USED();
			case INVALID_MAILSHARE_NAME:
				return INVALID_MAILSHARE_NAME();
			case INVALID_RESOURCE_NAME:
				return INVALID_RESOURCE_NAME();
			case OLD_PASSWORD_WRONG:
				return OLD_PASSWORD_WRONG();
			case OLD_PASSWORD_SAME_AS_NEW:
				return OLD_PASSWORD_SAME_AS_NEW();
			case IP_ADDRESS_ALREADY_USED:
				return IP_ADDRESS_ALREADY_USED();
			case MBOX_RENAME_FAILED:
				return MBOX_RENAME_FAILED();
			case INVALID_HOST_NAME:
				return INVALID_HOST_NAME();
			case EMPTY_EVENT_TITLE:
				return EMPTY_EVENT_TITLE();
			case NO_DURATION_EVENT:
				return NO_DURATION_EVENT();
			case NO_EVENT_DATE:
				return NO_EVENT_DATE();
			case NO_EVENT_TYPE:
				return NO_EVENT_TYPE();
			case EVENT_PRIVACY_INVALID:
				return EVENT_PRIVACY_INVALID();
			case EVENT_ERROR:
				return EVENT_ERROR();
			case CALENDAR_AUTHORISATION_ERROR:
				return CALENDAR_AUTHORISATION_ERROR();
			case CONTACT_DOMAIN_FORBIDDEN:
				return CONTACT_DOMAIN_FORBIDDEN();
			case EVENT_ENDREPEAT_PRIOR_TO_EVENT_DATE:
				return EVENT_ENDREPEAT_PRIOR_TO_EVENT_DATE();
			case INVALID_DOMAIN_NAME:
				return INVALID_DOMAIN_NAME();
			case GROUP_NAME_ALREADY_USED:
				return GROUP_NAME_ALREADY_USED();
			case INVALID_VACATION_RANGE:
				return INVALID_VACATION_RANGE();
			case EMPTY_DLIST_LABEL:
				return EMPTY_DLIST_LABEL();
			case EMPTY_DLIST_FOLDER:
				return EMPTY_DLIST_FOLDER();
			case DLIST_LOOP:
				return DLIST_LOOP();
			case CANT_UPDATE_ACL_IMPLICIT_RIGHTS:
				return CANT_UPDATE_ACL_IMPLICIT_RIGHTS();
			case USER_SPLIT_REQUIRES_SPLIT_DOMAIN:
				return USER_SPLIT_REQUIRES_SPLIT_DOMAIN();
			case SLAVE_RELAY_REQUIRES_SPLIT_DOMAIN:
				return SLAVE_RELAY_REQUIRES_SPLIT_DOMAIN();
			case INVALID_USER_LDAP_FILTER:
				return INVALID_USER_LDAP_FILTER();
			case SEC_GROUP_RM:
				return SEC_GROUP_RM();
			case NOT_IN_GLOBAL_DOMAIN:
				return NOT_IN_GLOBAL_DOMAIN();
			case NO_BACKUP_SERVER_FOUND:
				return NO_BACKUP_SERVER_FOUND();
			case OPERATION_ALREADY_RUNNING:
				return OPERATION_ALREADY_RUNNING();
			case INVALID_AD_HOST_NAME:
				return INVALID_AD_HOST_NAME();
			case JOB_FINISHED:
				return JOB_FINISHED();
			case INVALID_LICENSE:
				return INVALID_LICENSE();
			case HSM_MISSING_POLICY:
				return HSM_MISSING_POLICY();
			case INCOMPATIBLE_SMTP_TAGS:
				return INCOMPATIBLE_SMTP_TAGS();
			case INVALID_MAILBOX_NAME:
				return INVALID_MAILBOX_NAME();
			case TAG_ALREADY_EXIST:
				return TAG_ALREADY_EXIST();
			case INVALID_LINKED_MAILSHARE:
				return INVALID_LINKED_MAILSHARE();
			case MAILSHARE_GROUP_LINKED:
				return MAILSHARE_GROUP_LINKED();
			case SERVER_NOT_FOUND:
				return SERVER_NOT_FOUND();
			case DEPRECATED:
				return DEPRECATED();
			case INVALID_GROUP_MEMBER:
				return INVALID_GROUP_MEMBER();
			case EMPTY_EVENT_ATTACHMENT_VALUE:
				return EMPTY_EVENT_ATTACHMENT_VALUE();
			case TIMEOUT:
				return TIMEOUT();
			case VERSION_HAS_CHANGED:
				return VERSION_HAS_CHANGED();
			case MULTIPLE_EVENT_COUNTERS:
				return MULTIPLE_EVENT_COUNTERS();
			case EVENT_ACCEPTS_NO_COUNTERS:
				return EVENT_ACCEPTS_NO_COUNTERS();
			case EVENT_WEEKDAY_INVALID:
				return EVENT_WEEKDAY_INVALID();
			case EVENT_DUPLICATED_RECURID:
				return EVENT_DUPLICATED_RECURID();
			case MAX_ITEM_COUNT:
				return MAX_ITEM_COUNT();
			default:
				return null;
			}
		}
	}
}