/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.ldap.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class LdapAddressBookSockJsEndpoint implements net.bluemind.addressbook.ldap.api.ILdapAddressBookAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public LdapAddressBookSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/addressbookldap";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public LdapAddressBookSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void testConnection(net.bluemind.addressbook.ldap.api.LdapParameters ldapParameters, final AsyncHandler<net.bluemind.addressbook.ldap.api.ConnectionStatus> handler) {
		String postUri = "/_testConnection";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.addressbook.ldap.api.gwt.serder.LdapParametersGwtSerDer().serialize( ldapParameters);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.addressbook.ldap.api.ConnectionStatus>(handler) {
					@Override
			protected net.bluemind.addressbook.ldap.api.ConnectionStatus handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.addressbook.ldap.api.gwt.serder.ConnectionStatusGwtSerDer().deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.addressbook.ldap.api.ILdapAddressBookPromise promiseApi() {
		return new LdapAddressBookEndpointPromise(this);
	}

}
