/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.filehosting.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class FileHostingInfoGwtSerDer implements GwtSerDer<net.bluemind.filehosting.api.FileHostingInfo> {

	public FileHostingInfoGwtSerDer( ) {
	}

	@Override
	public net.bluemind.filehosting.api.FileHostingInfo deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.filehosting.api.FileHostingInfo ret = new net.bluemind.filehosting.api.FileHostingInfo();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.filehosting.api.FileHostingInfo ret, JSONObject json) {

		JSONValue presentJSON = json.get("present");
		ret.present =  GwtSerDerUtils.BOOLEAN.deserialize(presentJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.filehosting.api.gwt.serder.FileHostingInfoTypeGwtSerDer().deserialize(typeJSON);
		JSONValue infoJSON = json.get("info");
		ret.info =  GwtSerDerUtils.STRING.deserialize(infoJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.filehosting.api.FileHostingInfo o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.filehosting.api.FileHostingInfo o, JSONObject ret) {

		ret.put("present",  GwtSerDerUtils.BOOLEAN.serialize( o.present ));
		ret.put("type",  new net.bluemind.filehosting.api.gwt.serder.FileHostingInfoTypeGwtSerDer().serialize( o.type ));
		ret.put("info",  GwtSerDerUtils.STRING.serialize( o.info ));
	}
}