/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.filehosting.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class FileHostingSockJsEndpoint implements net.bluemind.filehosting.api.IFileHostingAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public FileHostingSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/filehosting/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}",pathVars[0]);
		
		baseUri = uri_;
	}

	public FileHostingSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void store(String path, Stream document, final AsyncHandler<Void> handler) {
		String postUri = "/{path}";

		postUri = postUri.replace("{path}", ""+path);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STREAM.serialize( document);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void list(String path, final AsyncHandler<List<net.bluemind.filehosting.api.FileHostingItem>> handler) {
		String postUri = "/_list";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("path", ""+path);
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.filehosting.api.FileHostingItem>>(handler) {
					@Override
			protected List<net.bluemind.filehosting.api.FileHostingItem> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.filehosting.api.gwt.serder.FileHostingItemGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void delete(String path, final AsyncHandler<Void> handler) {
		String postUri = "/{path}";

		postUri = postUri.replace("{path}", ""+path);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void getComplete(String uid, final AsyncHandler<net.bluemind.filehosting.api.FileHostingItem> handler) {
		String postUri = "/{uid}/_complete";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.filehosting.api.FileHostingItem>(handler) {
					@Override
			protected net.bluemind.filehosting.api.FileHostingItem handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.filehosting.api.gwt.serder.FileHostingItemGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getConfiguration(final AsyncHandler<net.bluemind.filehosting.api.Configuration> handler) {
		String postUri = "/_config";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.filehosting.api.Configuration>(handler) {
					@Override
			protected net.bluemind.filehosting.api.Configuration handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.filehosting.api.gwt.serder.ConfigurationGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void find(String query, final AsyncHandler<List<net.bluemind.filehosting.api.FileHostingItem>> handler) {
		String postUri = "/_find";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("query", ""+query);
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.filehosting.api.FileHostingItem>>(handler) {
					@Override
			protected List<net.bluemind.filehosting.api.FileHostingItem> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.filehosting.api.gwt.serder.FileHostingItemGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void unShare(String url, final AsyncHandler<Void> handler) {
		String postUri = "/{url}/unshare";

		postUri = postUri.replace("{url}", ""+url);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"DELETE",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void get(String path, final AsyncHandler<Stream> handler) {
		String postUri = "/{path}/_content";

		postUri = postUri.replace("{path}", ""+path);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Stream>(handler) {
					@Override
			protected Stream handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STREAM.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getSharedFile(String uid, final AsyncHandler<Stream> handler) {
		String postUri = "/{uid}/_public";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Stream>(handler) {
					@Override
			protected Stream handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STREAM.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void exists(String path, final AsyncHandler<Boolean> handler) {
		String postUri = "/{path}/_exists";

		postUri = postUri.replace("{path}", ""+path);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Boolean>(handler) {
					@Override
			protected Boolean handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.BOOLEAN.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void share(String path, Integer downloadLimit, String expirationDate, final AsyncHandler<net.bluemind.filehosting.api.FileHostingPublicLink> handler) {
		String postUri = "/_share";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("path", ""+path);
		params.put("downloadLimit", ""+downloadLimit);
		params.put("expirationDate", ""+expirationDate);
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.filehosting.api.FileHostingPublicLink>(handler) {
					@Override
			protected net.bluemind.filehosting.api.FileHostingPublicLink handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.filehosting.api.gwt.serder.FileHostingPublicLinkGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void info(final AsyncHandler<net.bluemind.filehosting.api.FileHostingInfo> handler) {
		String postUri = "/_info";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.filehosting.api.FileHostingInfo>(handler) {
					@Override
			protected net.bluemind.filehosting.api.FileHostingInfo handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.filehosting.api.gwt.serder.FileHostingInfoGwtSerDer().deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.filehosting.api.IFileHostingPromise promiseApi() {
		return new FileHostingEndpointPromise(this);
	}

}
