/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.filehosting.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class FileHostingGwtEndpoint implements net.bluemind.filehosting.api.IFileHostingAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public FileHostingGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/filehosting/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}",pathVars[0]);
		
		baseUri = uri_;
	}

	public FileHostingGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void store(String path, Stream document, final AsyncHandler<Void> handler) {
		String postUri = "/{path}";

		postUri = postUri.replace("{path}", ""+path);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.STREAM.serialize( document);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void list(String path, final AsyncHandler<List<net.bluemind.filehosting.api.FileHostingItem>> handler) {
		String postUri = "/_list";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&path=" + com.google.gwt.http.client.URL.encodeQueryString(""+path);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.filehosting.api.FileHostingItem>>(handler) {
			@Override
			protected List<net.bluemind.filehosting.api.FileHostingItem> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.filehosting.api.gwt.serder.FileHostingItemGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void delete(String path, final AsyncHandler<Void> handler) {
		String postUri = "/{path}";

		postUri = postUri.replace("{path}", ""+path);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getComplete(String uid, final AsyncHandler<net.bluemind.filehosting.api.FileHostingItem> handler) {
		String postUri = "/{uid}/_complete";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.filehosting.api.FileHostingItem>(handler) {
			@Override
			protected net.bluemind.filehosting.api.FileHostingItem handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.filehosting.api.gwt.serder.FileHostingItemGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getConfiguration(final AsyncHandler<net.bluemind.filehosting.api.Configuration> handler) {
		String postUri = "/_config";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.filehosting.api.Configuration>(handler) {
			@Override
			protected net.bluemind.filehosting.api.Configuration handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.filehosting.api.gwt.serder.ConfigurationGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void find(String query, final AsyncHandler<List<net.bluemind.filehosting.api.FileHostingItem>> handler) {
		String postUri = "/_find";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&query=" + com.google.gwt.http.client.URL.encodeQueryString(""+query);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.filehosting.api.FileHostingItem>>(handler) {
			@Override
			protected List<net.bluemind.filehosting.api.FileHostingItem> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.filehosting.api.gwt.serder.FileHostingItemGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void unShare(String url, final AsyncHandler<Void> handler) {
		String postUri = "/{url}/unshare";

		postUri = postUri.replace("{url}", ""+url);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void get(String path, final AsyncHandler<Stream> handler) {
		String postUri = "/{path}/_content";

		postUri = postUri.replace("{path}", ""+path);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Stream>(handler) {
			@Override
			protected Stream handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STREAM.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getSharedFile(String uid, final AsyncHandler<Stream> handler) {
		String postUri = "/{uid}/_public";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Stream>(handler) {
			@Override
			protected Stream handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STREAM.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void exists(String path, final AsyncHandler<Boolean> handler) {
		String postUri = "/{path}/_exists";

		postUri = postUri.replace("{path}", ""+path);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Boolean>(handler) {
			@Override
			protected Boolean handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.BOOLEAN.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void share(String path, Integer downloadLimit, String expirationDate, final AsyncHandler<net.bluemind.filehosting.api.FileHostingPublicLink> handler) {
		String postUri = "/_share";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&path=" + com.google.gwt.http.client.URL.encodeQueryString(""+path);
		queryParams += "&downloadLimit=" + com.google.gwt.http.client.URL.encodeQueryString(""+downloadLimit);
		queryParams += "&expirationDate=" + com.google.gwt.http.client.URL.encodeQueryString(""+expirationDate);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.filehosting.api.FileHostingPublicLink>(handler) {
			@Override
			protected net.bluemind.filehosting.api.FileHostingPublicLink handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.filehosting.api.gwt.serder.FileHostingPublicLinkGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void info(final AsyncHandler<net.bluemind.filehosting.api.FileHostingInfo> handler) {
		String postUri = "/_info";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.filehosting.api.FileHostingInfo>(handler) {
			@Override
			protected net.bluemind.filehosting.api.FileHostingInfo handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.filehosting.api.gwt.serder.FileHostingInfoGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.filehosting.api.IFileHostingPromise promiseApi() {
		return new FileHostingEndpointPromise(this);
	}
}
