package net.bluemind.filehosting.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.filehosting.api.IFileHostingAsync.class)
public interface IFileHostingPromise  {

	CompletableFuture<Void> store(java.lang.String path, net.bluemind.core.api.Stream document);

	CompletableFuture<java.util.List<net.bluemind.filehosting.api.FileHostingItem>> list(java.lang.String path);

	CompletableFuture<Void> delete(java.lang.String path);

	CompletableFuture<net.bluemind.filehosting.api.FileHostingItem> getComplete(java.lang.String uid);

	CompletableFuture<net.bluemind.filehosting.api.Configuration> getConfiguration();

	CompletableFuture<java.util.List<net.bluemind.filehosting.api.FileHostingItem>> find(java.lang.String query);

	CompletableFuture<Void> unShare(java.lang.String url);

	CompletableFuture<net.bluemind.core.api.Stream> get(java.lang.String path);

	CompletableFuture<net.bluemind.core.api.Stream> getSharedFile(java.lang.String uid);

	CompletableFuture<Boolean> exists(java.lang.String path);

	CompletableFuture<net.bluemind.filehosting.api.FileHostingPublicLink> share(java.lang.String path, java.lang.Integer downloadLimit, java.lang.String expirationDate);

	CompletableFuture<net.bluemind.filehosting.api.FileHostingInfo> info();

}