/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.calendar.handlers;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import net.bluemind.calendar.api.IPrintAsync;
import net.bluemind.calendar.api.PrintData;
import net.bluemind.calendar.api.PrintOptions;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.date.BmDateTimeWrapper;
import net.bluemind.core.rest.http.HttpClientProvider;
import net.bluemind.core.rest.http.ILocator;
import net.bluemind.core.rest.http.VertxServiceProvider;
import net.bluemind.network.topology.Topology;
import net.bluemind.server.api.Server;
import net.bluemind.webmodule.server.NeedVertx;

public class PrintCalendarHandler
implements Handler<HttpServerRequest>,
NeedVertx {
    private HttpClientProvider clientProvider;
    private static final ILocator locator = (string, asyncHandler) -> {
        String string2 = ((Server)Topology.get().core().value).address();
        String[] stringArray = new String[]{string2};
        asyncHandler.success((Object)stringArray);
    };

    public void handle(HttpServerRequest httpServerRequest) {
        httpServerRequest.exceptionHandler(this.errorHandler(httpServerRequest));
        PrintOptions printOptions = this.parseOptions(httpServerRequest);
        this.print(httpServerRequest, printOptions);
    }

    private PrintOptions parseOptions(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.params().get("view");
        String string2 = httpServerRequest.params().get("format");
        String string3 = httpServerRequest.params().get("dateBegin");
        String string4 = httpServerRequest.params().get("dateEnd");
        String string5 = httpServerRequest.params().get("color");
        String string6 = httpServerRequest.params().get("showDetail");
        String string7 = httpServerRequest.params().get("layout");
        List list = httpServerRequest.params().getAll("calendarUids");
        List list2 = httpServerRequest.params().getAll("calendarColors");
        PrintOptions printOptions = new PrintOptions();
        if (string != null) {
            printOptions.view = PrintOptions.PrintView.valueOf((String)string);
        }
        if (string2 != null) {
            printOptions.format = PrintOptions.PrintFormat.valueOf((String)string2);
        }
        if (string3 != null) {
            printOptions.dateBegin = BmDateTimeWrapper.create((String)string3);
        }
        if (string4 != null) {
            printOptions.dateEnd = BmDateTimeWrapper.create((String)string4);
        }
        if (string5 != null) {
            printOptions.color = Boolean.parseBoolean(string5);
        }
        if (string6 != null) {
            printOptions.showDetail = Boolean.parseBoolean(string6);
        }
        if (string7 != null) {
            printOptions.layout = PrintOptions.PrintLayout.valueOf((String)string7);
        }
        if (list != null) {
            JsonArray jsonArray = new JsonArray(list);
            ArrayList<PrintOptions.CalendarMetadata> arrayList = new ArrayList<PrintOptions.CalendarMetadata>(jsonArray.size());
            int n = 0;
            while (n < list.size()) {
                String string8 = (String)list.get(n);
                String string9 = (String)list2.get(n);
                arrayList.add(PrintOptions.CalendarMetadata.create((String)string8, (String)string9));
                ++n;
            }
            printOptions.calendars = arrayList;
        }
        return printOptions;
    }

    protected void print(final HttpServerRequest httpServerRequest, PrintOptions printOptions) {
        VertxServiceProvider vertxServiceProvider = this.getProvider(httpServerRequest);
        IPrintAsync iPrintAsync = (IPrintAsync)vertxServiceProvider.instance("bm/core", IPrintAsync.class, new String[0]);
        iPrintAsync.print(printOptions, (AsyncHandler)new AsyncHandler<PrintData>(){

            public void success(PrintData printData) {
                HttpServerResponse httpServerResponse = httpServerRequest.response();
                httpServerResponse.headers().add("Content-Disposition", "attachment; filename=\"calendar.pdf\"");
                httpServerResponse.headers().add("Content-Type", "application/pdf");
                httpServerResponse.end(Buffer.buffer((byte[])Base64.getDecoder().decode(printData.data.getBytes())));
            }

            public void failure(Throwable throwable) {
                HttpServerResponse httpServerResponse = httpServerRequest.response();
                httpServerResponse.setStatusCode(500);
                httpServerResponse.setStatusMessage(throwable.getMessage() != null ? throwable.getMessage() : "null");
                httpServerResponse.end();
            }
        });
    }

    private Handler<Throwable> errorHandler(final HttpServerRequest httpServerRequest) {
        return new Handler<Throwable>(){

            public void handle(Throwable throwable) {
                HttpServerResponse httpServerResponse = httpServerRequest.response();
                httpServerResponse.setStatusCode(500);
                httpServerResponse.setStatusMessage(throwable.getMessage() != null ? throwable.getMessage() : "null");
                httpServerResponse.end();
            }
        };
    }

    public void setVertx(Vertx vertx) {
        this.clientProvider = new HttpClientProvider(vertx);
    }

    private VertxServiceProvider getProvider(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.headers().get("BMSessionId");
        return new VertxServiceProvider(this.clientProvider, locator, string).from(httpServerRequest);
    }
}

