/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.calendar.filters;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.concurrent.CompletableFuture;
import net.bluemind.calendar.api.IPublishCalendarAsync;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.api.fault.ErrorCode;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.http.HttpClientProvider;
import net.bluemind.core.rest.http.ILocator;
import net.bluemind.core.rest.http.VertxServiceProvider;
import net.bluemind.core.rest.vertx.VertxStream;
import net.bluemind.network.topology.Topology;
import net.bluemind.server.api.Server;
import net.bluemind.webmodule.server.IWebFilter;
import net.bluemind.webmodule.server.NeedVertx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishCalendarFilter
implements IWebFilter,
NeedVertx {
    private static final Logger logger = LoggerFactory.getLogger(PublishCalendarFilter.class);
    private HttpClientProvider clientProvider;
    private static final ILocator locator = (string, asyncHandler) -> {
        String string2 = ((Server)Topology.get().core().value).address();
        String[] stringArray = new String[]{string2};
        asyncHandler.success((Object)stringArray);
    };

    public void setVertx(Vertx vertx) {
        this.clientProvider = new HttpClientProvider(vertx);
    }

    public CompletableFuture<HttpServerRequest> filter(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.path();
        if (!string.startsWith("/cal/calendar/publish")) {
            return CompletableFuture.completedFuture(httpServerRequest);
        }
        String string2 = httpServerRequest.path();
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error(unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
        String[] stringArray = string2.split("/");
        String string3 = stringArray[4];
        VertxServiceProvider vertxServiceProvider = new VertxServiceProvider(this.clientProvider, locator, null).from(httpServerRequest);
        ((IPublishCalendarAsync)vertxServiceProvider.instance("bm/core", IPublishCalendarAsync.class, new String[]{string3})).publish(stringArray[5], this.handler(httpServerRequest));
        return CompletableFuture.completedFuture(null);
    }

    private AsyncHandler<Stream> handler(final HttpServerRequest httpServerRequest) {
        return new AsyncHandler<Stream>(){

            public void success(Stream stream) {
                HttpServerResponse httpServerResponse = httpServerRequest.response();
                httpServerResponse.headers().set("Content-Type", "text/calendar;charset=UTF-8");
                httpServerResponse.headers().set("Content-Disposition", "attachment; filename=\"calendar.ics\"");
                ReadStream readStream = VertxStream.read((Stream)stream);
                httpServerResponse.setChunked(true);
                readStream.pipeTo((WriteStream)httpServerResponse);
            }

            public void failure(Throwable throwable) {
                int n = 500;
                if (throwable instanceof ServerFault) {
                    ErrorCode errorCode = ((ServerFault)throwable).getCode();
                    if (errorCode == ErrorCode.NOT_FOUND) {
                        n = 404;
                    } else if (errorCode == ErrorCode.PERMISSION_DENIED) {
                        n = 403;
                    }
                }
                httpServerRequest.response().setStatusCode(n);
                httpServerRequest.response().end();
            }
        };
    }
}

