/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailflow.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailRuleActionAssignmentDescriptorGwtSerDer implements GwtSerDer<net.bluemind.mailflow.api.MailRuleActionAssignmentDescriptor> {

	public MailRuleActionAssignmentDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailflow.api.MailRuleActionAssignmentDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailflow.api.MailRuleActionAssignmentDescriptor ret = new net.bluemind.mailflow.api.MailRuleActionAssignmentDescriptor();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.mailflow.api.MailRuleActionAssignmentDescriptor ret, JSONObject json) {

		JSONValue positionJSON = json.get("position");
		ret.position =  GwtSerDerUtils.INT.deserialize(positionJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		JSONValue rulesJSON = json.get("rules");
		ret.rules =  new net.bluemind.mailflow.api.gwt.serder.MailflowRuleGwtSerDer().deserialize(rulesJSON);
		JSONValue actionIdentifierJSON = json.get("actionIdentifier");
		ret.actionIdentifier =  GwtSerDerUtils.STRING.deserialize(actionIdentifierJSON);
		JSONValue groupJSON = json.get("group");
		ret.group =  GwtSerDerUtils.STRING.deserialize(groupJSON);
		JSONValue modeJSON = json.get("mode");
		ret.mode =  new net.bluemind.mailflow.api.gwt.serder.ExecutionModeGwtSerDer().deserialize(modeJSON);
		JSONValue routingJSON = json.get("routing");
		ret.routing =  new net.bluemind.mailflow.api.gwt.serder.MailflowRoutingGwtSerDer().deserialize(routingJSON);
		JSONValue actionConfigurationJSON = json.get("actionConfiguration");
		ret.actionConfiguration =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(actionConfigurationJSON);
		JSONValue isActiveJSON = json.get("isActive");
		ret.isActive =  GwtSerDerUtils.BOOLEAN.deserialize(isActiveJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.mailflow.api.MailRuleActionAssignmentDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailflow.api.MailRuleActionAssignmentDescriptor o, JSONObject ret) {

		ret.put("position",  GwtSerDerUtils.INT.serialize( o.position ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		ret.put("rules",  new net.bluemind.mailflow.api.gwt.serder.MailflowRuleGwtSerDer().serialize( o.rules ));
		ret.put("actionIdentifier",  GwtSerDerUtils.STRING.serialize( o.actionIdentifier ));
		ret.put("group",  GwtSerDerUtils.STRING.serialize( o.group ));
		ret.put("mode",  new net.bluemind.mailflow.api.gwt.serder.ExecutionModeGwtSerDer().serialize( o.mode ));
		ret.put("routing",  new net.bluemind.mailflow.api.gwt.serder.MailflowRoutingGwtSerDer().serialize( o.routing ));
		ret.put("actionConfiguration",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.actionConfiguration ));
		ret.put("isActive",  GwtSerDerUtils.BOOLEAN.serialize( o.isActive ));
	}
}