/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.hsm.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class HSMSockJsEndpoint implements net.bluemind.hsm.api.IHSMAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public HSMSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/hsm/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}",pathVars[0]);
		
		baseUri = uri_;
	}

	public HSMSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void promoteMultiple(List<net.bluemind.hsm.api.Promote> promote, final AsyncHandler<List<net.bluemind.hsm.api.TierChangeResult>> handler) {
		String postUri = "/_massPromote";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(new net.bluemind.hsm.api.gwt.serder.PromoteGwtSerDer()).serialize( promote);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.hsm.api.TierChangeResult>>(handler) {
					@Override
			protected List<net.bluemind.hsm.api.TierChangeResult> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.hsm.api.gwt.serder.TierChangeResultGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getSize(String mailboxUid, final AsyncHandler<Double> handler) {
		String postUri = "/_getSize/{mailboxUid}";

		postUri = postUri.replace("{mailboxUid}", ""+mailboxUid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Double>(handler) {
					@Override
			protected Double handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.DOUBLE.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void fetch(String mailboxUid, String hsmId, final AsyncHandler<byte[]> handler) {
		String postUri = "/_fetch/{mailboxUid}/{hsmId}";

		postUri = postUri.replace("{mailboxUid}", ""+mailboxUid);
		postUri = postUri.replace("{hsmId}", ""+hsmId);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<byte[]>(handler) {
					@Override
			protected byte[] handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ByteArraySerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void copy(String sourceMailboxUid, String destMailboxUid, List<String> hsmIds, final AsyncHandler<Void> handler) {
		String postUri = "/_copy/{sourceMailboxUid}/{destMailboxUid}";

		postUri = postUri.replace("{sourceMailboxUid}", ""+sourceMailboxUid);
		postUri = postUri.replace("{destMailboxUid}", ""+destMailboxUid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( hsmIds);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}

	public net.bluemind.hsm.api.IHSMPromise promiseApi() {
		return new HSMEndpointPromise(this);
	}

}
